package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OAuthListBuilder extends OAuthListFluentImpl<OAuthListBuilder> implements VisitableBuilder<OAuthList,OAuthListBuilder>{
  public OAuthListBuilder() {
    this(false);
  }
  public OAuthListBuilder(Boolean validationEnabled) {
    this(new OAuthList(), validationEnabled);
  }
  public OAuthListBuilder(OAuthListFluent<?> fluent) {
    this(fluent, false);
  }
  public OAuthListBuilder(OAuthListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OAuthList(), validationEnabled);
  }
  public OAuthListBuilder(OAuthListFluent<?> fluent,OAuthList instance) {
    this(fluent, instance, false);
  }
  public OAuthListBuilder(OAuthListFluent<?> fluent,OAuthList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OAuthListBuilder(OAuthList instance) {
    this(instance,false);
  }
  public OAuthListBuilder(OAuthList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  OAuthListFluent<?> fluent;
  Boolean validationEnabled;
  public OAuthList build() {
    OAuthList buildable = new OAuthList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}