package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OperandVersionBuilder extends OperandVersionFluentImpl<OperandVersionBuilder> implements VisitableBuilder<OperandVersion,OperandVersionBuilder>{
  public OperandVersionBuilder() {
    this(false);
  }
  public OperandVersionBuilder(Boolean validationEnabled) {
    this(new OperandVersion(), validationEnabled);
  }
  public OperandVersionBuilder(OperandVersionFluent<?> fluent) {
    this(fluent, false);
  }
  public OperandVersionBuilder(OperandVersionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OperandVersion(), validationEnabled);
  }
  public OperandVersionBuilder(OperandVersionFluent<?> fluent,OperandVersion instance) {
    this(fluent, instance, false);
  }
  public OperandVersionBuilder(OperandVersionFluent<?> fluent,OperandVersion instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withVersion(instance.getVersion()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OperandVersionBuilder(OperandVersion instance) {
    this(instance,false);
  }
  public OperandVersionBuilder(OperandVersion instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withVersion(instance.getVersion()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  OperandVersionFluent<?> fluent;
  Boolean validationEnabled;
  public OperandVersion build() {
    OperandVersion buildable = new OperandVersion(fluent.getName(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}