package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class RequiredHSTSPolicyFluentImpl<A extends RequiredHSTSPolicyFluent<A>> extends BaseFluent<A> implements RequiredHSTSPolicyFluent<A>{
  public RequiredHSTSPolicyFluentImpl() {
  }
  public RequiredHSTSPolicyFluentImpl(RequiredHSTSPolicy instance) {
    this.withDomainPatterns(instance.getDomainPatterns()); 
    this.withIncludeSubDomainsPolicy(instance.getIncludeSubDomainsPolicy()); 
    this.withMaxAge(instance.getMaxAge()); 
    this.withNamespaceSelector(instance.getNamespaceSelector()); 
    this.withPreloadPolicy(instance.getPreloadPolicy()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private List<String> domainPatterns = new ArrayList<String>();
  private String includeSubDomainsPolicy;
  private MaxAgePolicyBuilder maxAge;
  private LabelSelectorBuilder namespaceSelector;
  private String preloadPolicy;
  private Map<String,Object> additionalProperties;
  public A addToDomainPatterns(Integer index,String item) {
    if (this.domainPatterns == null) {this.domainPatterns = new ArrayList<String>();}
    this.domainPatterns.add(index, item);
    return (A)this;
  }
  public A setToDomainPatterns(Integer index,String item) {
    if (this.domainPatterns == null) {this.domainPatterns = new ArrayList<String>();}
    this.domainPatterns.set(index, item); return (A)this;
  }
  public A addToDomainPatterns(java.lang.String... items) {
    if (this.domainPatterns == null) {this.domainPatterns = new ArrayList<String>();}
    for (String item : items) {this.domainPatterns.add(item);} return (A)this;
  }
  public A addAllToDomainPatterns(Collection<String> items) {
    if (this.domainPatterns == null) {this.domainPatterns = new ArrayList<String>();}
    for (String item : items) {this.domainPatterns.add(item);} return (A)this;
  }
  public A removeFromDomainPatterns(java.lang.String... items) {
    for (String item : items) {if (this.domainPatterns!= null){ this.domainPatterns.remove(item);}} return (A)this;
  }
  public A removeAllFromDomainPatterns(Collection<String> items) {
    for (String item : items) {if (this.domainPatterns!= null){ this.domainPatterns.remove(item);}} return (A)this;
  }
  public List<String> getDomainPatterns() {
    return this.domainPatterns;
  }
  public String getDomainPattern(Integer index) {
    return this.domainPatterns.get(index);
  }
  public String getFirstDomainPattern() {
    return this.domainPatterns.get(0);
  }
  public String getLastDomainPattern() {
    return this.domainPatterns.get(domainPatterns.size() - 1);
  }
  public String getMatchingDomainPattern(Predicate<String> predicate) {
    for (String item: domainPatterns) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingDomainPattern(Predicate<String> predicate) {
    for (String item: domainPatterns) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDomainPatterns(List<String> domainPatterns) {
    if (domainPatterns != null) {this.domainPatterns = new ArrayList(); for (String item : domainPatterns){this.addToDomainPatterns(item);}} else { this.domainPatterns = null;} return (A) this;
  }
  public A withDomainPatterns(java.lang.String... domainPatterns) {
    if (this.domainPatterns != null) {this.domainPatterns.clear();}
    if (domainPatterns != null) {for (String item :domainPatterns){ this.addToDomainPatterns(item);}} return (A) this;
  }
  public Boolean hasDomainPatterns() {
    return domainPatterns != null && !domainPatterns.isEmpty();
  }
  public String getIncludeSubDomainsPolicy() {
    return this.includeSubDomainsPolicy;
  }
  public A withIncludeSubDomainsPolicy(String includeSubDomainsPolicy) {
    this.includeSubDomainsPolicy=includeSubDomainsPolicy; return (A) this;
  }
  public Boolean hasIncludeSubDomainsPolicy() {
    return this.includeSubDomainsPolicy != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMaxAge instead.
   * @return The buildable object.
   */
  @Deprecated
  public MaxAgePolicy getMaxAge() {
    return this.maxAge!=null ?this.maxAge.build():null;
  }
  public MaxAgePolicy buildMaxAge() {
    return this.maxAge!=null ?this.maxAge.build():null;
  }
  public A withMaxAge(MaxAgePolicy maxAge) {
    _visitables.get("maxAge").remove(this.maxAge);
    if (maxAge!=null){ this.maxAge= new MaxAgePolicyBuilder(maxAge); _visitables.get("maxAge").add(this.maxAge);} else { this.maxAge = null; _visitables.get("maxAge").remove(this.maxAge); } return (A) this;
  }
  public Boolean hasMaxAge() {
    return this.maxAge != null;
  }
  public A withNewMaxAge(Integer largestMaxAge,Integer smallestMaxAge) {
    return (A)withMaxAge(new MaxAgePolicy(largestMaxAge, smallestMaxAge));
  }
  public RequiredHSTSPolicyFluent.MaxAgeNested<A> withNewMaxAge() {
    return new RequiredHSTSPolicyFluentImpl.MaxAgeNestedImpl();
  }
  public RequiredHSTSPolicyFluent.MaxAgeNested<A> withNewMaxAgeLike(MaxAgePolicy item) {
    return new RequiredHSTSPolicyFluentImpl.MaxAgeNestedImpl(item);
  }
  public RequiredHSTSPolicyFluent.MaxAgeNested<A> editMaxAge() {
    return withNewMaxAgeLike(getMaxAge());
  }
  public RequiredHSTSPolicyFluent.MaxAgeNested<A> editOrNewMaxAge() {
    return withNewMaxAgeLike(getMaxAge() != null ? getMaxAge(): new MaxAgePolicyBuilder().build());
  }
  public RequiredHSTSPolicyFluent.MaxAgeNested<A> editOrNewMaxAgeLike(MaxAgePolicy item) {
    return withNewMaxAgeLike(getMaxAge() != null ? getMaxAge(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildNamespaceSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getNamespaceSelector() {
    return this.namespaceSelector!=null ?this.namespaceSelector.build():null;
  }
  public LabelSelector buildNamespaceSelector() {
    return this.namespaceSelector!=null ?this.namespaceSelector.build():null;
  }
  public A withNamespaceSelector(LabelSelector namespaceSelector) {
    _visitables.get("namespaceSelector").remove(this.namespaceSelector);
    if (namespaceSelector!=null){ this.namespaceSelector= new LabelSelectorBuilder(namespaceSelector); _visitables.get("namespaceSelector").add(this.namespaceSelector);} else { this.namespaceSelector = null; _visitables.get("namespaceSelector").remove(this.namespaceSelector); } return (A) this;
  }
  public Boolean hasNamespaceSelector() {
    return this.namespaceSelector != null;
  }
  public RequiredHSTSPolicyFluent.NamespaceSelectorNested<A> withNewNamespaceSelector() {
    return new RequiredHSTSPolicyFluentImpl.NamespaceSelectorNestedImpl();
  }
  public RequiredHSTSPolicyFluent.NamespaceSelectorNested<A> withNewNamespaceSelectorLike(LabelSelector item) {
    return new RequiredHSTSPolicyFluentImpl.NamespaceSelectorNestedImpl(item);
  }
  public RequiredHSTSPolicyFluent.NamespaceSelectorNested<A> editNamespaceSelector() {
    return withNewNamespaceSelectorLike(getNamespaceSelector());
  }
  public RequiredHSTSPolicyFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
    return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): new LabelSelectorBuilder().build());
  }
  public RequiredHSTSPolicyFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(LabelSelector item) {
    return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): item);
  }
  public String getPreloadPolicy() {
    return this.preloadPolicy;
  }
  public A withPreloadPolicy(String preloadPolicy) {
    this.preloadPolicy=preloadPolicy; return (A) this;
  }
  public Boolean hasPreloadPolicy() {
    return this.preloadPolicy != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RequiredHSTSPolicyFluentImpl that = (RequiredHSTSPolicyFluentImpl) o;
    if (domainPatterns != null ? !domainPatterns.equals(that.domainPatterns) :that.domainPatterns != null) return false;
    if (includeSubDomainsPolicy != null ? !includeSubDomainsPolicy.equals(that.includeSubDomainsPolicy) :that.includeSubDomainsPolicy != null) return false;
    if (maxAge != null ? !maxAge.equals(that.maxAge) :that.maxAge != null) return false;
    if (namespaceSelector != null ? !namespaceSelector.equals(that.namespaceSelector) :that.namespaceSelector != null) return false;
    if (preloadPolicy != null ? !preloadPolicy.equals(that.preloadPolicy) :that.preloadPolicy != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(domainPatterns,  includeSubDomainsPolicy,  maxAge,  namespaceSelector,  preloadPolicy,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (domainPatterns != null && !domainPatterns.isEmpty()) { sb.append("domainPatterns:"); sb.append(domainPatterns + ","); }
    if (includeSubDomainsPolicy != null) { sb.append("includeSubDomainsPolicy:"); sb.append(includeSubDomainsPolicy + ","); }
    if (maxAge != null) { sb.append("maxAge:"); sb.append(maxAge + ","); }
    if (namespaceSelector != null) { sb.append("namespaceSelector:"); sb.append(namespaceSelector + ","); }
    if (preloadPolicy != null) { sb.append("preloadPolicy:"); sb.append(preloadPolicy + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class MaxAgeNestedImpl<N> extends MaxAgePolicyFluentImpl<RequiredHSTSPolicyFluent.MaxAgeNested<N>> implements RequiredHSTSPolicyFluent.MaxAgeNested<N>,Nested<N>{
    MaxAgeNestedImpl(MaxAgePolicy item) {
      this.builder = new MaxAgePolicyBuilder(this, item);
    }
    MaxAgeNestedImpl() {
      this.builder = new MaxAgePolicyBuilder(this);
    }
    MaxAgePolicyBuilder builder;
    public N and() {
      return (N) RequiredHSTSPolicyFluentImpl.this.withMaxAge(builder.build());
    }
    public N endMaxAge() {
      return and();
    }
    
  }
  class NamespaceSelectorNestedImpl<N> extends LabelSelectorFluentImpl<RequiredHSTSPolicyFluent.NamespaceSelectorNested<N>> implements RequiredHSTSPolicyFluent.NamespaceSelectorNested<N>,Nested<N>{
    NamespaceSelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    NamespaceSelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) RequiredHSTSPolicyFluentImpl.this.withNamespaceSelector(builder.build());
    }
    public N endNamespaceSelector() {
      return and();
    }
    
  }
  
}