package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ExternalPlatformSpecBuilder extends ExternalPlatformSpecFluent<ExternalPlatformSpecBuilder> implements VisitableBuilder<ExternalPlatformSpec,ExternalPlatformSpecBuilder>{
  public ExternalPlatformSpecBuilder() {
    this(new ExternalPlatformSpec());
  }
  
  public ExternalPlatformSpecBuilder(ExternalPlatformSpecFluent<?> fluent) {
    this(fluent, new ExternalPlatformSpec());
  }
  
  public ExternalPlatformSpecBuilder(ExternalPlatformSpecFluent<?> fluent,ExternalPlatformSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ExternalPlatformSpecBuilder(ExternalPlatformSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ExternalPlatformSpecFluent<?> fluent;
  
  public ExternalPlatformSpec build() {
    ExternalPlatformSpec buildable = new ExternalPlatformSpec(fluent.getPlatformName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}