package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterVersionStatusBuilder extends ClusterVersionStatusFluentImpl<ClusterVersionStatusBuilder> implements VisitableBuilder<ClusterVersionStatus,ClusterVersionStatusBuilder>{
  public ClusterVersionStatusBuilder() {
    this(false);
  }
  public ClusterVersionStatusBuilder(Boolean validationEnabled) {
    this(new ClusterVersionStatus(), validationEnabled);
  }
  public ClusterVersionStatusBuilder(ClusterVersionStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterVersionStatusBuilder(ClusterVersionStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterVersionStatus(), validationEnabled);
  }
  public ClusterVersionStatusBuilder(ClusterVersionStatusFluent<?> fluent,ClusterVersionStatus instance) {
    this(fluent, instance, false);
  }
  public ClusterVersionStatusBuilder(ClusterVersionStatusFluent<?> fluent,ClusterVersionStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAvailableUpdates(instance.getAvailableUpdates()); 
    fluent.withConditionalUpdates(instance.getConditionalUpdates()); 
    fluent.withConditions(instance.getConditions()); 
    fluent.withDesired(instance.getDesired()); 
    fluent.withHistory(instance.getHistory()); 
    fluent.withObservedGeneration(instance.getObservedGeneration()); 
    fluent.withVersionHash(instance.getVersionHash()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClusterVersionStatusBuilder(ClusterVersionStatus instance) {
    this(instance,false);
  }
  public ClusterVersionStatusBuilder(ClusterVersionStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAvailableUpdates(instance.getAvailableUpdates()); 
    this.withConditionalUpdates(instance.getConditionalUpdates()); 
    this.withConditions(instance.getConditions()); 
    this.withDesired(instance.getDesired()); 
    this.withHistory(instance.getHistory()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
    this.withVersionHash(instance.getVersionHash()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ClusterVersionStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterVersionStatus build() {
    ClusterVersionStatus buildable = new ClusterVersionStatus(fluent.getAvailableUpdates(),fluent.getConditionalUpdates(),fluent.getConditions(),fluent.getDesired(),fluent.getHistory(),fluent.getObservedGeneration(),fluent.getVersionHash());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}