package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RegistryLocationBuilder extends RegistryLocationFluentImpl<RegistryLocationBuilder> implements VisitableBuilder<RegistryLocation,RegistryLocationBuilder>{
  public RegistryLocationBuilder() {
    this(false);
  }
  public RegistryLocationBuilder(Boolean validationEnabled) {
    this(new RegistryLocation(), validationEnabled);
  }
  public RegistryLocationBuilder(RegistryLocationFluent<?> fluent) {
    this(fluent, false);
  }
  public RegistryLocationBuilder(RegistryLocationFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RegistryLocation(), validationEnabled);
  }
  public RegistryLocationBuilder(RegistryLocationFluent<?> fluent,RegistryLocation instance) {
    this(fluent, instance, false);
  }
  public RegistryLocationBuilder(RegistryLocationFluent<?> fluent,RegistryLocation instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDomainName(instance.getDomainName()); 
    fluent.withInsecure(instance.getInsecure()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public RegistryLocationBuilder(RegistryLocation instance) {
    this(instance,false);
  }
  public RegistryLocationBuilder(RegistryLocation instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withDomainName(instance.getDomainName()); 
    this.withInsecure(instance.getInsecure()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  RegistryLocationFluent<?> fluent;
  Boolean validationEnabled;
  public RegistryLocation build() {
    RegistryLocation buildable = new RegistryLocation(fluent.getDomainName(),fluent.getInsecure());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}