package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class APIServerNamedServingCertBuilder extends APIServerNamedServingCertFluentImpl<APIServerNamedServingCertBuilder> implements VisitableBuilder<APIServerNamedServingCert,APIServerNamedServingCertBuilder>{
  public APIServerNamedServingCertBuilder() {
    this(false);
  }
  public APIServerNamedServingCertBuilder(Boolean validationEnabled) {
    this(new APIServerNamedServingCert(), validationEnabled);
  }
  public APIServerNamedServingCertBuilder(APIServerNamedServingCertFluent<?> fluent) {
    this(fluent, false);
  }
  public APIServerNamedServingCertBuilder(APIServerNamedServingCertFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new APIServerNamedServingCert(), validationEnabled);
  }
  public APIServerNamedServingCertBuilder(APIServerNamedServingCertFluent<?> fluent,APIServerNamedServingCert instance) {
    this(fluent, instance, false);
  }
  public APIServerNamedServingCertBuilder(APIServerNamedServingCertFluent<?> fluent,APIServerNamedServingCert instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withNames(instance.getNames()); 
    fluent.withServingCertificate(instance.getServingCertificate()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public APIServerNamedServingCertBuilder(APIServerNamedServingCert instance) {
    this(instance,false);
  }
  public APIServerNamedServingCertBuilder(APIServerNamedServingCert instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withNames(instance.getNames()); 
    this.withServingCertificate(instance.getServingCertificate()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  APIServerNamedServingCertFluent<?> fluent;
  Boolean validationEnabled;
  public APIServerNamedServingCert build() {
    APIServerNamedServingCert buildable = new APIServerNamedServingCert(fluent.getNames(),fluent.getServingCertificate());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}