package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface ComponentRouteStatusFluent<A extends ComponentRouteStatusFluent<A>> extends Fluent<A>{
  public A addToConditions(Integer index,Condition item);
  public A setToConditions(Integer index,Condition item);
  public A addToConditions(io.fabric8.kubernetes.api.model.Condition... items);
  public A addAllToConditions(Collection<Condition> items);
  public A removeFromConditions(io.fabric8.kubernetes.api.model.Condition... items);
  public A removeAllFromConditions(Collection<Condition> items);
  public List<Condition> getConditions();
  public Condition getCondition(Integer index);
  public Condition getFirstCondition();
  public Condition getLastCondition();
  public Condition getMatchingCondition(Predicate<Condition> predicate);
  public Boolean hasMatchingCondition(Predicate<Condition> predicate);
  public A withConditions(List<Condition> conditions);
  public A withConditions(io.fabric8.kubernetes.api.model.Condition... conditions);
  public Boolean hasConditions();
  public A addToConsumingUsers(Integer index,String item);
  public A setToConsumingUsers(Integer index,String item);
  public A addToConsumingUsers(java.lang.String... items);
  public A addAllToConsumingUsers(Collection<String> items);
  public A removeFromConsumingUsers(java.lang.String... items);
  public A removeAllFromConsumingUsers(Collection<String> items);
  public List<String> getConsumingUsers();
  public String getConsumingUser(Integer index);
  public String getFirstConsumingUser();
  public String getLastConsumingUser();
  public String getMatchingConsumingUser(Predicate<String> predicate);
  public Boolean hasMatchingConsumingUser(Predicate<String> predicate);
  public A withConsumingUsers(List<String> consumingUsers);
  public A withConsumingUsers(java.lang.String... consumingUsers);
  public Boolean hasConsumingUsers();
  public A addToCurrentHostnames(Integer index,String item);
  public A setToCurrentHostnames(Integer index,String item);
  public A addToCurrentHostnames(java.lang.String... items);
  public A addAllToCurrentHostnames(Collection<String> items);
  public A removeFromCurrentHostnames(java.lang.String... items);
  public A removeAllFromCurrentHostnames(Collection<String> items);
  public List<String> getCurrentHostnames();
  public String getCurrentHostname(Integer index);
  public String getFirstCurrentHostname();
  public String getLastCurrentHostname();
  public String getMatchingCurrentHostname(Predicate<String> predicate);
  public Boolean hasMatchingCurrentHostname(Predicate<String> predicate);
  public A withCurrentHostnames(List<String> currentHostnames);
  public A withCurrentHostnames(java.lang.String... currentHostnames);
  public Boolean hasCurrentHostnames();
  public String getDefaultHostname();
  public A withDefaultHostname(String defaultHostname);
  public Boolean hasDefaultHostname();
  public String getName();
  public A withName(String name);
  public Boolean hasName();
  public String getNamespace();
  public A withNamespace(String namespace);
  public Boolean hasNamespace();
  public A addToRelatedObjects(Integer index,ObjectReference item);
  public A setToRelatedObjects(Integer index,ObjectReference item);
  public A addToRelatedObjects(io.fabric8.openshift.api.model.config.v1.ObjectReference... items);
  public A addAllToRelatedObjects(Collection<ObjectReference> items);
  public A removeFromRelatedObjects(io.fabric8.openshift.api.model.config.v1.ObjectReference... items);
  public A removeAllFromRelatedObjects(Collection<ObjectReference> items);
  public A removeMatchingFromRelatedObjects(Predicate<ObjectReferenceBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildRelatedObjects instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ObjectReference> getRelatedObjects();
  public List<ObjectReference> buildRelatedObjects();
  public ObjectReference buildRelatedObject(Integer index);
  public ObjectReference buildFirstRelatedObject();
  public ObjectReference buildLastRelatedObject();
  public ObjectReference buildMatchingRelatedObject(Predicate<ObjectReferenceBuilder> predicate);
  public Boolean hasMatchingRelatedObject(Predicate<ObjectReferenceBuilder> predicate);
  public A withRelatedObjects(List<ObjectReference> relatedObjects);
  public A withRelatedObjects(io.fabric8.openshift.api.model.config.v1.ObjectReference... relatedObjects);
  public Boolean hasRelatedObjects();
  public A addNewRelatedObject(String group,String name,String namespace,String resource);
  public ComponentRouteStatusFluent.RelatedObjectsNested<A> addNewRelatedObject();
  public ComponentRouteStatusFluent.RelatedObjectsNested<A> addNewRelatedObjectLike(ObjectReference item);
  public ComponentRouteStatusFluent.RelatedObjectsNested<A> setNewRelatedObjectLike(Integer index,ObjectReference item);
  public ComponentRouteStatusFluent.RelatedObjectsNested<A> editRelatedObject(Integer index);
  public ComponentRouteStatusFluent.RelatedObjectsNested<A> editFirstRelatedObject();
  public ComponentRouteStatusFluent.RelatedObjectsNested<A> editLastRelatedObject();
  public ComponentRouteStatusFluent.RelatedObjectsNested<A> editMatchingRelatedObject(Predicate<ObjectReferenceBuilder> predicate);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface RelatedObjectsNested<N> extends Nested<N>,ObjectReferenceFluent<ComponentRouteStatusFluent.RelatedObjectsNested<N>>{
    public N and();
    public N endRelatedObject();
    
  }
  
}