package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface NetworkStatusFluent<A extends NetworkStatusFluent<A>> extends Fluent<A>{
  public A addToClusterNetwork(Integer index,ClusterNetworkEntry item);
  public A setToClusterNetwork(Integer index,ClusterNetworkEntry item);
  public A addToClusterNetwork(io.fabric8.openshift.api.model.config.v1.ClusterNetworkEntry... items);
  public A addAllToClusterNetwork(Collection<ClusterNetworkEntry> items);
  public A removeFromClusterNetwork(io.fabric8.openshift.api.model.config.v1.ClusterNetworkEntry... items);
  public A removeAllFromClusterNetwork(Collection<ClusterNetworkEntry> items);
  public A removeMatchingFromClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildClusterNetwork instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ClusterNetworkEntry> getClusterNetwork();
  public List<ClusterNetworkEntry> buildClusterNetwork();
  public ClusterNetworkEntry buildClusterNetwork(Integer index);
  public ClusterNetworkEntry buildFirstClusterNetwork();
  public ClusterNetworkEntry buildLastClusterNetwork();
  public ClusterNetworkEntry buildMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate);
  public Boolean hasMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate);
  public A withClusterNetwork(List<ClusterNetworkEntry> clusterNetwork);
  public A withClusterNetwork(io.fabric8.openshift.api.model.config.v1.ClusterNetworkEntry... clusterNetwork);
  public Boolean hasClusterNetwork();
  public A addNewClusterNetwork(String cidr,Integer hostPrefix);
  public NetworkStatusFluent.ClusterNetworkNested<A> addNewClusterNetwork();
  public NetworkStatusFluent.ClusterNetworkNested<A> addNewClusterNetworkLike(ClusterNetworkEntry item);
  public NetworkStatusFluent.ClusterNetworkNested<A> setNewClusterNetworkLike(Integer index,ClusterNetworkEntry item);
  public NetworkStatusFluent.ClusterNetworkNested<A> editClusterNetwork(Integer index);
  public NetworkStatusFluent.ClusterNetworkNested<A> editFirstClusterNetwork();
  public NetworkStatusFluent.ClusterNetworkNested<A> editLastClusterNetwork();
  public NetworkStatusFluent.ClusterNetworkNested<A> editMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate);
  public Integer getClusterNetworkMTU();
  public A withClusterNetworkMTU(Integer clusterNetworkMTU);
  public Boolean hasClusterNetworkMTU();
  
  /**
   * This method has been deprecated, please use method buildMigration instead.
   * @return The buildable object.
   */
  @Deprecated
  public NetworkMigration getMigration();
  public NetworkMigration buildMigration();
  public A withMigration(NetworkMigration migration);
  public Boolean hasMigration();
  public A withNewMigration(String networkType);
  public NetworkStatusFluent.MigrationNested<A> withNewMigration();
  public NetworkStatusFluent.MigrationNested<A> withNewMigrationLike(NetworkMigration item);
  public NetworkStatusFluent.MigrationNested<A> editMigration();
  public NetworkStatusFluent.MigrationNested<A> editOrNewMigration();
  public NetworkStatusFluent.MigrationNested<A> editOrNewMigrationLike(NetworkMigration item);
  public String getNetworkType();
  public A withNetworkType(String networkType);
  public Boolean hasNetworkType();
  public A addToServiceNetwork(Integer index,String item);
  public A setToServiceNetwork(Integer index,String item);
  public A addToServiceNetwork(java.lang.String... items);
  public A addAllToServiceNetwork(Collection<String> items);
  public A removeFromServiceNetwork(java.lang.String... items);
  public A removeAllFromServiceNetwork(Collection<String> items);
  public List<String> getServiceNetwork();
  public String getServiceNetwork(Integer index);
  public String getFirstServiceNetwork();
  public String getLastServiceNetwork();
  public String getMatchingServiceNetwork(Predicate<String> predicate);
  public Boolean hasMatchingServiceNetwork(Predicate<String> predicate);
  public A withServiceNetwork(List<String> serviceNetwork);
  public A withServiceNetwork(java.lang.String... serviceNetwork);
  public Boolean hasServiceNetwork();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ClusterNetworkNested<N> extends Nested<N>,ClusterNetworkEntryFluent<NetworkStatusFluent.ClusterNetworkNested<N>>{
    public N and();
    public N endClusterNetwork();
    
  }
  public interface MigrationNested<N> extends Nested<N>,NetworkMigrationFluent<NetworkStatusFluent.MigrationNested<N>>{
    public N and();
    public N endMigration();
    
  }
  
}