package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PowerVSPlatformSpecBuilder extends PowerVSPlatformSpecFluentImpl<PowerVSPlatformSpecBuilder> implements VisitableBuilder<PowerVSPlatformSpec,PowerVSPlatformSpecBuilder>{
  public PowerVSPlatformSpecBuilder() {
    this(false);
  }
  public PowerVSPlatformSpecBuilder(Boolean validationEnabled) {
    this(new PowerVSPlatformSpec(), validationEnabled);
  }
  public PowerVSPlatformSpecBuilder(PowerVSPlatformSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public PowerVSPlatformSpecBuilder(PowerVSPlatformSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PowerVSPlatformSpec(), validationEnabled);
  }
  public PowerVSPlatformSpecBuilder(PowerVSPlatformSpecFluent<?> fluent,PowerVSPlatformSpec instance) {
    this(fluent, instance, false);
  }
  public PowerVSPlatformSpecBuilder(PowerVSPlatformSpecFluent<?> fluent,PowerVSPlatformSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withServiceEndpoints(instance.getServiceEndpoints()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PowerVSPlatformSpecBuilder(PowerVSPlatformSpec instance) {
    this(instance,false);
  }
  public PowerVSPlatformSpecBuilder(PowerVSPlatformSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withServiceEndpoints(instance.getServiceEndpoints()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  PowerVSPlatformSpecFluent<?> fluent;
  Boolean validationEnabled;
  public PowerVSPlatformSpec build() {
    PowerVSPlatformSpec buildable = new PowerVSPlatformSpec(fluent.getServiceEndpoints());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}