package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ProxySpecFluentImpl<A extends ProxySpecFluent<A>> extends BaseFluent<A> implements ProxySpecFluent<A>{
  public ProxySpecFluentImpl() {
  }
  public ProxySpecFluentImpl(ProxySpec instance) {
    this.withHttpProxy(instance.getHttpProxy()); 
    this.withHttpsProxy(instance.getHttpsProxy()); 
    this.withNoProxy(instance.getNoProxy()); 
    this.withReadinessEndpoints(instance.getReadinessEndpoints()); 
    this.withTrustedCA(instance.getTrustedCA()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String httpProxy;
  private String httpsProxy;
  private String noProxy;
  private List<String> readinessEndpoints = new ArrayList<String>();
  private ConfigMapNameReferenceBuilder trustedCA;
  private Map<String,Object> additionalProperties;
  public String getHttpProxy() {
    return this.httpProxy;
  }
  public A withHttpProxy(String httpProxy) {
    this.httpProxy=httpProxy; return (A) this;
  }
  public Boolean hasHttpProxy() {
    return this.httpProxy != null;
  }
  public String getHttpsProxy() {
    return this.httpsProxy;
  }
  public A withHttpsProxy(String httpsProxy) {
    this.httpsProxy=httpsProxy; return (A) this;
  }
  public Boolean hasHttpsProxy() {
    return this.httpsProxy != null;
  }
  public String getNoProxy() {
    return this.noProxy;
  }
  public A withNoProxy(String noProxy) {
    this.noProxy=noProxy; return (A) this;
  }
  public Boolean hasNoProxy() {
    return this.noProxy != null;
  }
  public A addToReadinessEndpoints(Integer index,String item) {
    if (this.readinessEndpoints == null) {this.readinessEndpoints = new ArrayList<String>();}
    this.readinessEndpoints.add(index, item);
    return (A)this;
  }
  public A setToReadinessEndpoints(Integer index,String item) {
    if (this.readinessEndpoints == null) {this.readinessEndpoints = new ArrayList<String>();}
    this.readinessEndpoints.set(index, item); return (A)this;
  }
  public A addToReadinessEndpoints(java.lang.String... items) {
    if (this.readinessEndpoints == null) {this.readinessEndpoints = new ArrayList<String>();}
    for (String item : items) {this.readinessEndpoints.add(item);} return (A)this;
  }
  public A addAllToReadinessEndpoints(Collection<String> items) {
    if (this.readinessEndpoints == null) {this.readinessEndpoints = new ArrayList<String>();}
    for (String item : items) {this.readinessEndpoints.add(item);} return (A)this;
  }
  public A removeFromReadinessEndpoints(java.lang.String... items) {
    for (String item : items) {if (this.readinessEndpoints!= null){ this.readinessEndpoints.remove(item);}} return (A)this;
  }
  public A removeAllFromReadinessEndpoints(Collection<String> items) {
    for (String item : items) {if (this.readinessEndpoints!= null){ this.readinessEndpoints.remove(item);}} return (A)this;
  }
  public List<String> getReadinessEndpoints() {
    return this.readinessEndpoints;
  }
  public String getReadinessEndpoint(Integer index) {
    return this.readinessEndpoints.get(index);
  }
  public String getFirstReadinessEndpoint() {
    return this.readinessEndpoints.get(0);
  }
  public String getLastReadinessEndpoint() {
    return this.readinessEndpoints.get(readinessEndpoints.size() - 1);
  }
  public String getMatchingReadinessEndpoint(Predicate<String> predicate) {
    for (String item: readinessEndpoints) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingReadinessEndpoint(Predicate<String> predicate) {
    for (String item: readinessEndpoints) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withReadinessEndpoints(List<String> readinessEndpoints) {
    if (readinessEndpoints != null) {this.readinessEndpoints = new ArrayList(); for (String item : readinessEndpoints){this.addToReadinessEndpoints(item);}} else { this.readinessEndpoints = null;} return (A) this;
  }
  public A withReadinessEndpoints(java.lang.String... readinessEndpoints) {
    if (this.readinessEndpoints != null) {this.readinessEndpoints.clear();}
    if (readinessEndpoints != null) {for (String item :readinessEndpoints){ this.addToReadinessEndpoints(item);}} return (A) this;
  }
  public Boolean hasReadinessEndpoints() {
    return readinessEndpoints != null && !readinessEndpoints.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildTrustedCA instead.
   * @return The buildable object.
   */
  @Deprecated
  public ConfigMapNameReference getTrustedCA() {
    return this.trustedCA!=null ?this.trustedCA.build():null;
  }
  public ConfigMapNameReference buildTrustedCA() {
    return this.trustedCA!=null ?this.trustedCA.build():null;
  }
  public A withTrustedCA(ConfigMapNameReference trustedCA) {
    _visitables.get("trustedCA").remove(this.trustedCA);
    if (trustedCA!=null){ this.trustedCA= new ConfigMapNameReferenceBuilder(trustedCA); _visitables.get("trustedCA").add(this.trustedCA);} else { this.trustedCA = null; _visitables.get("trustedCA").remove(this.trustedCA); } return (A) this;
  }
  public Boolean hasTrustedCA() {
    return this.trustedCA != null;
  }
  public A withNewTrustedCA(String name) {
    return (A)withTrustedCA(new ConfigMapNameReference(name));
  }
  public ProxySpecFluent.TrustedCANested<A> withNewTrustedCA() {
    return new ProxySpecFluentImpl.TrustedCANestedImpl();
  }
  public ProxySpecFluent.TrustedCANested<A> withNewTrustedCALike(ConfigMapNameReference item) {
    return new ProxySpecFluentImpl.TrustedCANestedImpl(item);
  }
  public ProxySpecFluent.TrustedCANested<A> editTrustedCA() {
    return withNewTrustedCALike(getTrustedCA());
  }
  public ProxySpecFluent.TrustedCANested<A> editOrNewTrustedCA() {
    return withNewTrustedCALike(getTrustedCA() != null ? getTrustedCA(): new ConfigMapNameReferenceBuilder().build());
  }
  public ProxySpecFluent.TrustedCANested<A> editOrNewTrustedCALike(ConfigMapNameReference item) {
    return withNewTrustedCALike(getTrustedCA() != null ? getTrustedCA(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProxySpecFluentImpl that = (ProxySpecFluentImpl) o;
    if (httpProxy != null ? !httpProxy.equals(that.httpProxy) :that.httpProxy != null) return false;
    if (httpsProxy != null ? !httpsProxy.equals(that.httpsProxy) :that.httpsProxy != null) return false;
    if (noProxy != null ? !noProxy.equals(that.noProxy) :that.noProxy != null) return false;
    if (readinessEndpoints != null ? !readinessEndpoints.equals(that.readinessEndpoints) :that.readinessEndpoints != null) return false;
    if (trustedCA != null ? !trustedCA.equals(that.trustedCA) :that.trustedCA != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(httpProxy,  httpsProxy,  noProxy,  readinessEndpoints,  trustedCA,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (httpProxy != null) { sb.append("httpProxy:"); sb.append(httpProxy + ","); }
    if (httpsProxy != null) { sb.append("httpsProxy:"); sb.append(httpsProxy + ","); }
    if (noProxy != null) { sb.append("noProxy:"); sb.append(noProxy + ","); }
    if (readinessEndpoints != null && !readinessEndpoints.isEmpty()) { sb.append("readinessEndpoints:"); sb.append(readinessEndpoints + ","); }
    if (trustedCA != null) { sb.append("trustedCA:"); sb.append(trustedCA + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class TrustedCANestedImpl<N> extends ConfigMapNameReferenceFluentImpl<ProxySpecFluent.TrustedCANested<N>> implements ProxySpecFluent.TrustedCANested<N>,Nested<N>{
    TrustedCANestedImpl(ConfigMapNameReference item) {
      this.builder = new ConfigMapNameReferenceBuilder(this, item);
    }
    TrustedCANestedImpl() {
      this.builder = new ConfigMapNameReferenceBuilder(this);
    }
    ConfigMapNameReferenceBuilder builder;
    public N and() {
      return (N) ProxySpecFluentImpl.this.withTrustedCA(builder.build());
    }
    public N endTrustedCA() {
      return and();
    }
    
  }
  
}