package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConditionalUpdateRiskBuilder extends ConditionalUpdateRiskFluentImpl<ConditionalUpdateRiskBuilder> implements VisitableBuilder<ConditionalUpdateRisk,ConditionalUpdateRiskBuilder>{
  public ConditionalUpdateRiskBuilder() {
    this(false);
  }
  public ConditionalUpdateRiskBuilder(Boolean validationEnabled) {
    this(new ConditionalUpdateRisk(), validationEnabled);
  }
  public ConditionalUpdateRiskBuilder(ConditionalUpdateRiskFluent<?> fluent) {
    this(fluent, false);
  }
  public ConditionalUpdateRiskBuilder(ConditionalUpdateRiskFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConditionalUpdateRisk(), validationEnabled);
  }
  public ConditionalUpdateRiskBuilder(ConditionalUpdateRiskFluent<?> fluent,ConditionalUpdateRisk instance) {
    this(fluent, instance, false);
  }
  public ConditionalUpdateRiskBuilder(ConditionalUpdateRiskFluent<?> fluent,ConditionalUpdateRisk instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMatchingRules(instance.getMatchingRules()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withName(instance.getName()); 
    fluent.withUrl(instance.getUrl()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ConditionalUpdateRiskBuilder(ConditionalUpdateRisk instance) {
    this(instance,false);
  }
  public ConditionalUpdateRiskBuilder(ConditionalUpdateRisk instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withMatchingRules(instance.getMatchingRules()); 
    this.withMessage(instance.getMessage()); 
    this.withName(instance.getName()); 
    this.withUrl(instance.getUrl()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ConditionalUpdateRiskFluent<?> fluent;
  Boolean validationEnabled;
  public ConditionalUpdateRisk build() {
    ConditionalUpdateRisk buildable = new ConditionalUpdateRisk(fluent.getMatchingRules(),fluent.getMessage(),fluent.getName(),fluent.getUrl());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}