package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CustomTLSProfileFluentImpl<A extends CustomTLSProfileFluent<A>> extends BaseFluent<A> implements CustomTLSProfileFluent<A>{
  public CustomTLSProfileFluentImpl() {
  }
  public CustomTLSProfileFluentImpl(CustomTLSProfile instance) {
    this.withCiphers(instance.getCiphers()); 
    this.withMinTLSVersion(instance.getMinTLSVersion()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private List<String> ciphers = new ArrayList<String>();
  private String minTLSVersion;
  private Map<String,Object> additionalProperties;
  public A addToCiphers(Integer index,String item) {
    if (this.ciphers == null) {this.ciphers = new ArrayList<String>();}
    this.ciphers.add(index, item);
    return (A)this;
  }
  public A setToCiphers(Integer index,String item) {
    if (this.ciphers == null) {this.ciphers = new ArrayList<String>();}
    this.ciphers.set(index, item); return (A)this;
  }
  public A addToCiphers(java.lang.String... items) {
    if (this.ciphers == null) {this.ciphers = new ArrayList<String>();}
    for (String item : items) {this.ciphers.add(item);} return (A)this;
  }
  public A addAllToCiphers(Collection<String> items) {
    if (this.ciphers == null) {this.ciphers = new ArrayList<String>();}
    for (String item : items) {this.ciphers.add(item);} return (A)this;
  }
  public A removeFromCiphers(java.lang.String... items) {
    for (String item : items) {if (this.ciphers!= null){ this.ciphers.remove(item);}} return (A)this;
  }
  public A removeAllFromCiphers(Collection<String> items) {
    for (String item : items) {if (this.ciphers!= null){ this.ciphers.remove(item);}} return (A)this;
  }
  public List<String> getCiphers() {
    return this.ciphers;
  }
  public String getCipher(Integer index) {
    return this.ciphers.get(index);
  }
  public String getFirstCipher() {
    return this.ciphers.get(0);
  }
  public String getLastCipher() {
    return this.ciphers.get(ciphers.size() - 1);
  }
  public String getMatchingCipher(Predicate<String> predicate) {
    for (String item: ciphers) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingCipher(Predicate<String> predicate) {
    for (String item: ciphers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withCiphers(List<String> ciphers) {
    if (ciphers != null) {this.ciphers = new ArrayList(); for (String item : ciphers){this.addToCiphers(item);}} else { this.ciphers = null;} return (A) this;
  }
  public A withCiphers(java.lang.String... ciphers) {
    if (this.ciphers != null) {this.ciphers.clear();}
    if (ciphers != null) {for (String item :ciphers){ this.addToCiphers(item);}} return (A) this;
  }
  public Boolean hasCiphers() {
    return ciphers != null && !ciphers.isEmpty();
  }
  public String getMinTLSVersion() {
    return this.minTLSVersion;
  }
  public A withMinTLSVersion(String minTLSVersion) {
    this.minTLSVersion=minTLSVersion; return (A) this;
  }
  public Boolean hasMinTLSVersion() {
    return this.minTLSVersion != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomTLSProfileFluentImpl that = (CustomTLSProfileFluentImpl) o;
    if (ciphers != null ? !ciphers.equals(that.ciphers) :that.ciphers != null) return false;
    if (minTLSVersion != null ? !minTLSVersion.equals(that.minTLSVersion) :that.minTLSVersion != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(ciphers,  minTLSVersion,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (ciphers != null && !ciphers.isEmpty()) { sb.append("ciphers:"); sb.append(ciphers + ","); }
    if (minTLSVersion != null) { sb.append("minTLSVersion:"); sb.append(minTLSVersion + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}