package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KeystoneIdentityProviderFluentImpl<A extends KeystoneIdentityProviderFluent<A>> extends BaseFluent<A> implements KeystoneIdentityProviderFluent<A>{
  public KeystoneIdentityProviderFluentImpl() {
  }
  public KeystoneIdentityProviderFluentImpl(KeystoneIdentityProvider instance) {
    this.withCa(instance.getCa()); 
    this.withDomainName(instance.getDomainName()); 
    this.withTlsClientCert(instance.getTlsClientCert()); 
    this.withTlsClientKey(instance.getTlsClientKey()); 
    this.withUrl(instance.getUrl()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ConfigMapNameReferenceBuilder ca;
  private String domainName;
  private SecretNameReferenceBuilder tlsClientCert;
  private SecretNameReferenceBuilder tlsClientKey;
  private String url;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildCa instead.
   * @return The buildable object.
   */
  @Deprecated
  public ConfigMapNameReference getCa() {
    return this.ca!=null ?this.ca.build():null;
  }
  public ConfigMapNameReference buildCa() {
    return this.ca!=null ?this.ca.build():null;
  }
  public A withCa(ConfigMapNameReference ca) {
    _visitables.get("ca").remove(this.ca);
    if (ca!=null){ this.ca= new ConfigMapNameReferenceBuilder(ca); _visitables.get("ca").add(this.ca);} else { this.ca = null; _visitables.get("ca").remove(this.ca); } return (A) this;
  }
  public Boolean hasCa() {
    return this.ca != null;
  }
  public A withNewCa(String name) {
    return (A)withCa(new ConfigMapNameReference(name));
  }
  public KeystoneIdentityProviderFluent.CaNested<A> withNewCa() {
    return new KeystoneIdentityProviderFluentImpl.CaNestedImpl();
  }
  public KeystoneIdentityProviderFluent.CaNested<A> withNewCaLike(ConfigMapNameReference item) {
    return new KeystoneIdentityProviderFluentImpl.CaNestedImpl(item);
  }
  public KeystoneIdentityProviderFluent.CaNested<A> editCa() {
    return withNewCaLike(getCa());
  }
  public KeystoneIdentityProviderFluent.CaNested<A> editOrNewCa() {
    return withNewCaLike(getCa() != null ? getCa(): new ConfigMapNameReferenceBuilder().build());
  }
  public KeystoneIdentityProviderFluent.CaNested<A> editOrNewCaLike(ConfigMapNameReference item) {
    return withNewCaLike(getCa() != null ? getCa(): item);
  }
  public String getDomainName() {
    return this.domainName;
  }
  public A withDomainName(String domainName) {
    this.domainName=domainName; return (A) this;
  }
  public Boolean hasDomainName() {
    return this.domainName != null;
  }
  
  /**
   * This method has been deprecated, please use method buildTlsClientCert instead.
   * @return The buildable object.
   */
  @Deprecated
  public SecretNameReference getTlsClientCert() {
    return this.tlsClientCert!=null ?this.tlsClientCert.build():null;
  }
  public SecretNameReference buildTlsClientCert() {
    return this.tlsClientCert!=null ?this.tlsClientCert.build():null;
  }
  public A withTlsClientCert(SecretNameReference tlsClientCert) {
    _visitables.get("tlsClientCert").remove(this.tlsClientCert);
    if (tlsClientCert!=null){ this.tlsClientCert= new SecretNameReferenceBuilder(tlsClientCert); _visitables.get("tlsClientCert").add(this.tlsClientCert);} else { this.tlsClientCert = null; _visitables.get("tlsClientCert").remove(this.tlsClientCert); } return (A) this;
  }
  public Boolean hasTlsClientCert() {
    return this.tlsClientCert != null;
  }
  public A withNewTlsClientCert(String name) {
    return (A)withTlsClientCert(new SecretNameReference(name));
  }
  public KeystoneIdentityProviderFluent.TlsClientCertNested<A> withNewTlsClientCert() {
    return new KeystoneIdentityProviderFluentImpl.TlsClientCertNestedImpl();
  }
  public KeystoneIdentityProviderFluent.TlsClientCertNested<A> withNewTlsClientCertLike(SecretNameReference item) {
    return new KeystoneIdentityProviderFluentImpl.TlsClientCertNestedImpl(item);
  }
  public KeystoneIdentityProviderFluent.TlsClientCertNested<A> editTlsClientCert() {
    return withNewTlsClientCertLike(getTlsClientCert());
  }
  public KeystoneIdentityProviderFluent.TlsClientCertNested<A> editOrNewTlsClientCert() {
    return withNewTlsClientCertLike(getTlsClientCert() != null ? getTlsClientCert(): new SecretNameReferenceBuilder().build());
  }
  public KeystoneIdentityProviderFluent.TlsClientCertNested<A> editOrNewTlsClientCertLike(SecretNameReference item) {
    return withNewTlsClientCertLike(getTlsClientCert() != null ? getTlsClientCert(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildTlsClientKey instead.
   * @return The buildable object.
   */
  @Deprecated
  public SecretNameReference getTlsClientKey() {
    return this.tlsClientKey!=null ?this.tlsClientKey.build():null;
  }
  public SecretNameReference buildTlsClientKey() {
    return this.tlsClientKey!=null ?this.tlsClientKey.build():null;
  }
  public A withTlsClientKey(SecretNameReference tlsClientKey) {
    _visitables.get("tlsClientKey").remove(this.tlsClientKey);
    if (tlsClientKey!=null){ this.tlsClientKey= new SecretNameReferenceBuilder(tlsClientKey); _visitables.get("tlsClientKey").add(this.tlsClientKey);} else { this.tlsClientKey = null; _visitables.get("tlsClientKey").remove(this.tlsClientKey); } return (A) this;
  }
  public Boolean hasTlsClientKey() {
    return this.tlsClientKey != null;
  }
  public A withNewTlsClientKey(String name) {
    return (A)withTlsClientKey(new SecretNameReference(name));
  }
  public KeystoneIdentityProviderFluent.TlsClientKeyNested<A> withNewTlsClientKey() {
    return new KeystoneIdentityProviderFluentImpl.TlsClientKeyNestedImpl();
  }
  public KeystoneIdentityProviderFluent.TlsClientKeyNested<A> withNewTlsClientKeyLike(SecretNameReference item) {
    return new KeystoneIdentityProviderFluentImpl.TlsClientKeyNestedImpl(item);
  }
  public KeystoneIdentityProviderFluent.TlsClientKeyNested<A> editTlsClientKey() {
    return withNewTlsClientKeyLike(getTlsClientKey());
  }
  public KeystoneIdentityProviderFluent.TlsClientKeyNested<A> editOrNewTlsClientKey() {
    return withNewTlsClientKeyLike(getTlsClientKey() != null ? getTlsClientKey(): new SecretNameReferenceBuilder().build());
  }
  public KeystoneIdentityProviderFluent.TlsClientKeyNested<A> editOrNewTlsClientKeyLike(SecretNameReference item) {
    return withNewTlsClientKeyLike(getTlsClientKey() != null ? getTlsClientKey(): item);
  }
  public String getUrl() {
    return this.url;
  }
  public A withUrl(String url) {
    this.url=url; return (A) this;
  }
  public Boolean hasUrl() {
    return this.url != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    KeystoneIdentityProviderFluentImpl that = (KeystoneIdentityProviderFluentImpl) o;
    if (ca != null ? !ca.equals(that.ca) :that.ca != null) return false;
    if (domainName != null ? !domainName.equals(that.domainName) :that.domainName != null) return false;
    if (tlsClientCert != null ? !tlsClientCert.equals(that.tlsClientCert) :that.tlsClientCert != null) return false;
    if (tlsClientKey != null ? !tlsClientKey.equals(that.tlsClientKey) :that.tlsClientKey != null) return false;
    if (url != null ? !url.equals(that.url) :that.url != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(ca,  domainName,  tlsClientCert,  tlsClientKey,  url,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (ca != null) { sb.append("ca:"); sb.append(ca + ","); }
    if (domainName != null) { sb.append("domainName:"); sb.append(domainName + ","); }
    if (tlsClientCert != null) { sb.append("tlsClientCert:"); sb.append(tlsClientCert + ","); }
    if (tlsClientKey != null) { sb.append("tlsClientKey:"); sb.append(tlsClientKey + ","); }
    if (url != null) { sb.append("url:"); sb.append(url + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class CaNestedImpl<N> extends ConfigMapNameReferenceFluentImpl<KeystoneIdentityProviderFluent.CaNested<N>> implements KeystoneIdentityProviderFluent.CaNested<N>,Nested<N>{
    CaNestedImpl(ConfigMapNameReference item) {
      this.builder = new ConfigMapNameReferenceBuilder(this, item);
    }
    CaNestedImpl() {
      this.builder = new ConfigMapNameReferenceBuilder(this);
    }
    ConfigMapNameReferenceBuilder builder;
    public N and() {
      return (N) KeystoneIdentityProviderFluentImpl.this.withCa(builder.build());
    }
    public N endCa() {
      return and();
    }
    
  }
  class TlsClientCertNestedImpl<N> extends SecretNameReferenceFluentImpl<KeystoneIdentityProviderFluent.TlsClientCertNested<N>> implements KeystoneIdentityProviderFluent.TlsClientCertNested<N>,Nested<N>{
    TlsClientCertNestedImpl(SecretNameReference item) {
      this.builder = new SecretNameReferenceBuilder(this, item);
    }
    TlsClientCertNestedImpl() {
      this.builder = new SecretNameReferenceBuilder(this);
    }
    SecretNameReferenceBuilder builder;
    public N and() {
      return (N) KeystoneIdentityProviderFluentImpl.this.withTlsClientCert(builder.build());
    }
    public N endTlsClientCert() {
      return and();
    }
    
  }
  class TlsClientKeyNestedImpl<N> extends SecretNameReferenceFluentImpl<KeystoneIdentityProviderFluent.TlsClientKeyNested<N>> implements KeystoneIdentityProviderFluent.TlsClientKeyNested<N>,Nested<N>{
    TlsClientKeyNestedImpl(SecretNameReference item) {
      this.builder = new SecretNameReferenceBuilder(this, item);
    }
    TlsClientKeyNestedImpl() {
      this.builder = new SecretNameReferenceBuilder(this);
    }
    SecretNameReferenceBuilder builder;
    public N and() {
      return (N) KeystoneIdentityProviderFluentImpl.this.withTlsClientKey(builder.build());
    }
    public N endTlsClientKey() {
      return and();
    }
    
  }
  
}