package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class LDAPAttributeMappingFluentImpl<A extends LDAPAttributeMappingFluent<A>> extends BaseFluent<A> implements LDAPAttributeMappingFluent<A>{
  public LDAPAttributeMappingFluentImpl() {
  }
  public LDAPAttributeMappingFluentImpl(LDAPAttributeMapping instance) {
    this.withEmail(instance.getEmail()); 
    this.withId(instance.getId()); 
    this.withName(instance.getName()); 
    this.withPreferredUsername(instance.getPreferredUsername()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private List<String> email = new ArrayList<String>();
  private List<String> id = new ArrayList<String>();
  private List<String> name = new ArrayList<String>();
  private List<String> preferredUsername = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  public A addToEmail(Integer index,String item) {
    if (this.email == null) {this.email = new ArrayList<String>();}
    this.email.add(index, item);
    return (A)this;
  }
  public A setToEmail(Integer index,String item) {
    if (this.email == null) {this.email = new ArrayList<String>();}
    this.email.set(index, item); return (A)this;
  }
  public A addToEmail(java.lang.String... items) {
    if (this.email == null) {this.email = new ArrayList<String>();}
    for (String item : items) {this.email.add(item);} return (A)this;
  }
  public A addAllToEmail(Collection<String> items) {
    if (this.email == null) {this.email = new ArrayList<String>();}
    for (String item : items) {this.email.add(item);} return (A)this;
  }
  public A removeFromEmail(java.lang.String... items) {
    for (String item : items) {if (this.email!= null){ this.email.remove(item);}} return (A)this;
  }
  public A removeAllFromEmail(Collection<String> items) {
    for (String item : items) {if (this.email!= null){ this.email.remove(item);}} return (A)this;
  }
  public List<String> getEmail() {
    return this.email;
  }
  public String getEmail(Integer index) {
    return this.email.get(index);
  }
  public String getFirstEmail() {
    return this.email.get(0);
  }
  public String getLastEmail() {
    return this.email.get(email.size() - 1);
  }
  public String getMatchingEmail(Predicate<String> predicate) {
    for (String item: email) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingEmail(Predicate<String> predicate) {
    for (String item: email) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEmail(List<String> email) {
    if (email != null) {this.email = new ArrayList(); for (String item : email){this.addToEmail(item);}} else { this.email = null;} return (A) this;
  }
  public A withEmail(java.lang.String... email) {
    if (this.email != null) {this.email.clear();}
    if (email != null) {for (String item :email){ this.addToEmail(item);}} return (A) this;
  }
  public Boolean hasEmail() {
    return email != null && !email.isEmpty();
  }
  public A addToId(Integer index,String item) {
    if (this.id == null) {this.id = new ArrayList<String>();}
    this.id.add(index, item);
    return (A)this;
  }
  public A setToId(Integer index,String item) {
    if (this.id == null) {this.id = new ArrayList<String>();}
    this.id.set(index, item); return (A)this;
  }
  public A addToId(java.lang.String... items) {
    if (this.id == null) {this.id = new ArrayList<String>();}
    for (String item : items) {this.id.add(item);} return (A)this;
  }
  public A addAllToId(Collection<String> items) {
    if (this.id == null) {this.id = new ArrayList<String>();}
    for (String item : items) {this.id.add(item);} return (A)this;
  }
  public A removeFromId(java.lang.String... items) {
    for (String item : items) {if (this.id!= null){ this.id.remove(item);}} return (A)this;
  }
  public A removeAllFromId(Collection<String> items) {
    for (String item : items) {if (this.id!= null){ this.id.remove(item);}} return (A)this;
  }
  public List<String> getId() {
    return this.id;
  }
  public String getId(Integer index) {
    return this.id.get(index);
  }
  public String getFirstId() {
    return this.id.get(0);
  }
  public String getLastId() {
    return this.id.get(id.size() - 1);
  }
  public String getMatchingId(Predicate<String> predicate) {
    for (String item: id) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingId(Predicate<String> predicate) {
    for (String item: id) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withId(List<String> id) {
    if (id != null) {this.id = new ArrayList(); for (String item : id){this.addToId(item);}} else { this.id = null;} return (A) this;
  }
  public A withId(java.lang.String... id) {
    if (this.id != null) {this.id.clear();}
    if (id != null) {for (String item :id){ this.addToId(item);}} return (A) this;
  }
  public Boolean hasId() {
    return id != null && !id.isEmpty();
  }
  public A addToName(Integer index,String item) {
    if (this.name == null) {this.name = new ArrayList<String>();}
    this.name.add(index, item);
    return (A)this;
  }
  public A setToName(Integer index,String item) {
    if (this.name == null) {this.name = new ArrayList<String>();}
    this.name.set(index, item); return (A)this;
  }
  public A addToName(java.lang.String... items) {
    if (this.name == null) {this.name = new ArrayList<String>();}
    for (String item : items) {this.name.add(item);} return (A)this;
  }
  public A addAllToName(Collection<String> items) {
    if (this.name == null) {this.name = new ArrayList<String>();}
    for (String item : items) {this.name.add(item);} return (A)this;
  }
  public A removeFromName(java.lang.String... items) {
    for (String item : items) {if (this.name!= null){ this.name.remove(item);}} return (A)this;
  }
  public A removeAllFromName(Collection<String> items) {
    for (String item : items) {if (this.name!= null){ this.name.remove(item);}} return (A)this;
  }
  public List<String> getName() {
    return this.name;
  }
  public String getName(Integer index) {
    return this.name.get(index);
  }
  public String getFirstName() {
    return this.name.get(0);
  }
  public String getLastName() {
    return this.name.get(name.size() - 1);
  }
  public String getMatchingName(Predicate<String> predicate) {
    for (String item: name) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingName(Predicate<String> predicate) {
    for (String item: name) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withName(List<String> name) {
    if (name != null) {this.name = new ArrayList(); for (String item : name){this.addToName(item);}} else { this.name = null;} return (A) this;
  }
  public A withName(java.lang.String... name) {
    if (this.name != null) {this.name.clear();}
    if (name != null) {for (String item :name){ this.addToName(item);}} return (A) this;
  }
  public Boolean hasName() {
    return name != null && !name.isEmpty();
  }
  public A addToPreferredUsername(Integer index,String item) {
    if (this.preferredUsername == null) {this.preferredUsername = new ArrayList<String>();}
    this.preferredUsername.add(index, item);
    return (A)this;
  }
  public A setToPreferredUsername(Integer index,String item) {
    if (this.preferredUsername == null) {this.preferredUsername = new ArrayList<String>();}
    this.preferredUsername.set(index, item); return (A)this;
  }
  public A addToPreferredUsername(java.lang.String... items) {
    if (this.preferredUsername == null) {this.preferredUsername = new ArrayList<String>();}
    for (String item : items) {this.preferredUsername.add(item);} return (A)this;
  }
  public A addAllToPreferredUsername(Collection<String> items) {
    if (this.preferredUsername == null) {this.preferredUsername = new ArrayList<String>();}
    for (String item : items) {this.preferredUsername.add(item);} return (A)this;
  }
  public A removeFromPreferredUsername(java.lang.String... items) {
    for (String item : items) {if (this.preferredUsername!= null){ this.preferredUsername.remove(item);}} return (A)this;
  }
  public A removeAllFromPreferredUsername(Collection<String> items) {
    for (String item : items) {if (this.preferredUsername!= null){ this.preferredUsername.remove(item);}} return (A)this;
  }
  public List<String> getPreferredUsername() {
    return this.preferredUsername;
  }
  public String getPreferredUsername(Integer index) {
    return this.preferredUsername.get(index);
  }
  public String getFirstPreferredUsername() {
    return this.preferredUsername.get(0);
  }
  public String getLastPreferredUsername() {
    return this.preferredUsername.get(preferredUsername.size() - 1);
  }
  public String getMatchingPreferredUsername(Predicate<String> predicate) {
    for (String item: preferredUsername) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingPreferredUsername(Predicate<String> predicate) {
    for (String item: preferredUsername) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPreferredUsername(List<String> preferredUsername) {
    if (preferredUsername != null) {this.preferredUsername = new ArrayList(); for (String item : preferredUsername){this.addToPreferredUsername(item);}} else { this.preferredUsername = null;} return (A) this;
  }
  public A withPreferredUsername(java.lang.String... preferredUsername) {
    if (this.preferredUsername != null) {this.preferredUsername.clear();}
    if (preferredUsername != null) {for (String item :preferredUsername){ this.addToPreferredUsername(item);}} return (A) this;
  }
  public Boolean hasPreferredUsername() {
    return preferredUsername != null && !preferredUsername.isEmpty();
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    LDAPAttributeMappingFluentImpl that = (LDAPAttributeMappingFluentImpl) o;
    if (email != null ? !email.equals(that.email) :that.email != null) return false;
    if (id != null ? !id.equals(that.id) :that.id != null) return false;
    if (name != null ? !name.equals(that.name) :that.name != null) return false;
    if (preferredUsername != null ? !preferredUsername.equals(that.preferredUsername) :that.preferredUsername != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(email,  id,  name,  preferredUsername,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (email != null && !email.isEmpty()) { sb.append("email:"); sb.append(email + ","); }
    if (id != null && !id.isEmpty()) { sb.append("id:"); sb.append(id + ","); }
    if (name != null && !name.isEmpty()) { sb.append("name:"); sb.append(name + ","); }
    if (preferredUsername != null && !preferredUsername.isEmpty()) { sb.append("preferredUsername:"); sb.append(preferredUsername + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}