package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OpenStackPlatformStatusBuilder extends OpenStackPlatformStatusFluentImpl<OpenStackPlatformStatusBuilder> implements VisitableBuilder<OpenStackPlatformStatus,OpenStackPlatformStatusBuilder>{
  public OpenStackPlatformStatusBuilder() {
    this(false);
  }
  public OpenStackPlatformStatusBuilder(Boolean validationEnabled) {
    this(new OpenStackPlatformStatus(), validationEnabled);
  }
  public OpenStackPlatformStatusBuilder(OpenStackPlatformStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public OpenStackPlatformStatusBuilder(OpenStackPlatformStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OpenStackPlatformStatus(), validationEnabled);
  }
  public OpenStackPlatformStatusBuilder(OpenStackPlatformStatusFluent<?> fluent,OpenStackPlatformStatus instance) {
    this(fluent, instance, false);
  }
  public OpenStackPlatformStatusBuilder(OpenStackPlatformStatusFluent<?> fluent,OpenStackPlatformStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiServerInternalIP(instance.getApiServerInternalIP()); 
    fluent.withCloudName(instance.getCloudName()); 
    fluent.withIngressIP(instance.getIngressIP()); 
    fluent.withNodeDNSIP(instance.getNodeDNSIP()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OpenStackPlatformStatusBuilder(OpenStackPlatformStatus instance) {
    this(instance,false);
  }
  public OpenStackPlatformStatusBuilder(OpenStackPlatformStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiServerInternalIP(instance.getApiServerInternalIP()); 
    this.withCloudName(instance.getCloudName()); 
    this.withIngressIP(instance.getIngressIP()); 
    this.withNodeDNSIP(instance.getNodeDNSIP()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  OpenStackPlatformStatusFluent<?> fluent;
  Boolean validationEnabled;
  public OpenStackPlatformStatus build() {
    OpenStackPlatformStatus buildable = new OpenStackPlatformStatus(fluent.getApiServerInternalIP(),fluent.getCloudName(),fluent.getIngressIP(),fluent.getNodeDNSIP());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}