package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterOperatorBuilder extends ClusterOperatorFluentImpl<ClusterOperatorBuilder> implements VisitableBuilder<ClusterOperator,ClusterOperatorBuilder>{
  public ClusterOperatorBuilder() {
    this(false);
  }
  public ClusterOperatorBuilder(Boolean validationEnabled) {
    this(new ClusterOperator(), validationEnabled);
  }
  public ClusterOperatorBuilder(ClusterOperatorFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterOperatorBuilder(ClusterOperatorFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterOperator(), validationEnabled);
  }
  public ClusterOperatorBuilder(ClusterOperatorFluent<?> fluent,ClusterOperator instance) {
    this(fluent, instance, false);
  }
  public ClusterOperatorBuilder(ClusterOperatorFluent<?> fluent,ClusterOperator instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClusterOperatorBuilder(ClusterOperator instance) {
    this(instance,false);
  }
  public ClusterOperatorBuilder(ClusterOperator instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ClusterOperatorFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterOperator build() {
    ClusterOperator buildable = new ClusterOperator(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}