package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsoleAuthenticationBuilder extends ConsoleAuthenticationFluentImpl<ConsoleAuthenticationBuilder> implements VisitableBuilder<ConsoleAuthentication,ConsoleAuthenticationBuilder>{
  public ConsoleAuthenticationBuilder() {
    this(false);
  }
  public ConsoleAuthenticationBuilder(Boolean validationEnabled) {
    this(new ConsoleAuthentication(), validationEnabled);
  }
  public ConsoleAuthenticationBuilder(ConsoleAuthenticationFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsoleAuthenticationBuilder(ConsoleAuthenticationFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConsoleAuthentication(), validationEnabled);
  }
  public ConsoleAuthenticationBuilder(ConsoleAuthenticationFluent<?> fluent,ConsoleAuthentication instance) {
    this(fluent, instance, false);
  }
  public ConsoleAuthenticationBuilder(ConsoleAuthenticationFluent<?> fluent,ConsoleAuthentication instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLogoutRedirect(instance.getLogoutRedirect()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ConsoleAuthenticationBuilder(ConsoleAuthentication instance) {
    this(instance,false);
  }
  public ConsoleAuthenticationBuilder(ConsoleAuthentication instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withLogoutRedirect(instance.getLogoutRedirect()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ConsoleAuthenticationFluent<?> fluent;
  Boolean validationEnabled;
  public ConsoleAuthentication build() {
    ConsoleAuthentication buildable = new ConsoleAuthentication(fluent.getLogoutRedirect());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}