package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ExternalIPPolicyBuilder extends ExternalIPPolicyFluentImpl<ExternalIPPolicyBuilder> implements VisitableBuilder<ExternalIPPolicy,ExternalIPPolicyBuilder>{
  public ExternalIPPolicyBuilder() {
    this(false);
  }
  public ExternalIPPolicyBuilder(Boolean validationEnabled) {
    this(new ExternalIPPolicy(), validationEnabled);
  }
  public ExternalIPPolicyBuilder(ExternalIPPolicyFluent<?> fluent) {
    this(fluent, false);
  }
  public ExternalIPPolicyBuilder(ExternalIPPolicyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ExternalIPPolicy(), validationEnabled);
  }
  public ExternalIPPolicyBuilder(ExternalIPPolicyFluent<?> fluent,ExternalIPPolicy instance) {
    this(fluent, instance, false);
  }
  public ExternalIPPolicyBuilder(ExternalIPPolicyFluent<?> fluent,ExternalIPPolicy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAllowedCIDRs(instance.getAllowedCIDRs()); 
    fluent.withRejectedCIDRs(instance.getRejectedCIDRs()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ExternalIPPolicyBuilder(ExternalIPPolicy instance) {
    this(instance,false);
  }
  public ExternalIPPolicyBuilder(ExternalIPPolicy instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAllowedCIDRs(instance.getAllowedCIDRs()); 
    this.withRejectedCIDRs(instance.getRejectedCIDRs()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ExternalIPPolicyFluent<?> fluent;
  Boolean validationEnabled;
  public ExternalIPPolicy build() {
    ExternalIPPolicy buildable = new ExternalIPPolicy(fluent.getAllowedCIDRs(),fluent.getRejectedCIDRs());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}