package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class APIServerServingCertsFluentImpl<A extends APIServerServingCertsFluent<A>> extends BaseFluent<A> implements APIServerServingCertsFluent<A>{
  public APIServerServingCertsFluentImpl() {
  }
  public APIServerServingCertsFluentImpl(APIServerServingCerts instance) {
    if (instance != null) {
      this.withNamedCertificates(instance.getNamedCertificates());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ArrayList<APIServerNamedServingCertBuilder> namedCertificates = new ArrayList<APIServerNamedServingCertBuilder>();
  private Map<String,Object> additionalProperties;
  public A addToNamedCertificates(int index,APIServerNamedServingCert item) {
    if (this.namedCertificates == null) {this.namedCertificates = new ArrayList<APIServerNamedServingCertBuilder>();}
    APIServerNamedServingCertBuilder builder = new APIServerNamedServingCertBuilder(item);
    if (index < 0 || index >= namedCertificates.size()) { _visitables.get("namedCertificates").add(builder); namedCertificates.add(builder); } else { _visitables.get("namedCertificates").add(index, builder); namedCertificates.add(index, builder);}
    return (A)this;
  }
  public A setToNamedCertificates(int index,APIServerNamedServingCert item) {
    if (this.namedCertificates == null) {this.namedCertificates = new ArrayList<APIServerNamedServingCertBuilder>();}
    APIServerNamedServingCertBuilder builder = new APIServerNamedServingCertBuilder(item);
    if (index < 0 || index >= namedCertificates.size()) { _visitables.get("namedCertificates").add(builder); namedCertificates.add(builder); } else { _visitables.get("namedCertificates").set(index, builder); namedCertificates.set(index, builder);}
    return (A)this;
  }
  public A addToNamedCertificates(io.fabric8.openshift.api.model.config.v1.APIServerNamedServingCert... items) {
    if (this.namedCertificates == null) {this.namedCertificates = new ArrayList<APIServerNamedServingCertBuilder>();}
    for (APIServerNamedServingCert item : items) {APIServerNamedServingCertBuilder builder = new APIServerNamedServingCertBuilder(item);_visitables.get("namedCertificates").add(builder);this.namedCertificates.add(builder);} return (A)this;
  }
  public A addAllToNamedCertificates(Collection<APIServerNamedServingCert> items) {
    if (this.namedCertificates == null) {this.namedCertificates = new ArrayList<APIServerNamedServingCertBuilder>();}
    for (APIServerNamedServingCert item : items) {APIServerNamedServingCertBuilder builder = new APIServerNamedServingCertBuilder(item);_visitables.get("namedCertificates").add(builder);this.namedCertificates.add(builder);} return (A)this;
  }
  public A removeFromNamedCertificates(io.fabric8.openshift.api.model.config.v1.APIServerNamedServingCert... items) {
    for (APIServerNamedServingCert item : items) {APIServerNamedServingCertBuilder builder = new APIServerNamedServingCertBuilder(item);_visitables.get("namedCertificates").remove(builder);if (this.namedCertificates != null) {this.namedCertificates.remove(builder);}} return (A)this;
  }
  public A removeAllFromNamedCertificates(Collection<APIServerNamedServingCert> items) {
    for (APIServerNamedServingCert item : items) {APIServerNamedServingCertBuilder builder = new APIServerNamedServingCertBuilder(item);_visitables.get("namedCertificates").remove(builder);if (this.namedCertificates != null) {this.namedCertificates.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromNamedCertificates(Predicate<APIServerNamedServingCertBuilder> predicate) {
    if (namedCertificates == null) return (A) this;
    final Iterator<APIServerNamedServingCertBuilder> each = namedCertificates.iterator();
    final List visitables = _visitables.get("namedCertificates");
    while (each.hasNext()) {
      APIServerNamedServingCertBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildNamedCertificates instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<APIServerNamedServingCert> getNamedCertificates() {
    return namedCertificates != null ? build(namedCertificates) : null;
  }
  public List<APIServerNamedServingCert> buildNamedCertificates() {
    return namedCertificates != null ? build(namedCertificates) : null;
  }
  public APIServerNamedServingCert buildNamedCertificate(int index) {
    return this.namedCertificates.get(index).build();
  }
  public APIServerNamedServingCert buildFirstNamedCertificate() {
    return this.namedCertificates.get(0).build();
  }
  public APIServerNamedServingCert buildLastNamedCertificate() {
    return this.namedCertificates.get(namedCertificates.size() - 1).build();
  }
  public APIServerNamedServingCert buildMatchingNamedCertificate(Predicate<APIServerNamedServingCertBuilder> predicate) {
    for (APIServerNamedServingCertBuilder item: namedCertificates) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingNamedCertificate(Predicate<APIServerNamedServingCertBuilder> predicate) {
    for (APIServerNamedServingCertBuilder item: namedCertificates) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withNamedCertificates(List<APIServerNamedServingCert> namedCertificates) {
    if (this.namedCertificates != null) { _visitables.get("namedCertificates").clear();}
    if (namedCertificates != null) {this.namedCertificates = new ArrayList(); for (APIServerNamedServingCert item : namedCertificates){this.addToNamedCertificates(item);}} else { this.namedCertificates = null;} return (A) this;
  }
  public A withNamedCertificates(io.fabric8.openshift.api.model.config.v1.APIServerNamedServingCert... namedCertificates) {
    if (this.namedCertificates != null) {this.namedCertificates.clear(); _visitables.remove("namedCertificates"); }
    if (namedCertificates != null) {for (APIServerNamedServingCert item :namedCertificates){ this.addToNamedCertificates(item);}} return (A) this;
  }
  public Boolean hasNamedCertificates() {
    return namedCertificates != null && !namedCertificates.isEmpty();
  }
  public APIServerServingCertsFluentImpl.NamedCertificatesNested<A> addNewNamedCertificate() {
    return new APIServerServingCertsFluentImpl.NamedCertificatesNestedImpl();
  }
  public APIServerServingCertsFluentImpl.NamedCertificatesNested<A> addNewNamedCertificateLike(APIServerNamedServingCert item) {
    return new APIServerServingCertsFluentImpl.NamedCertificatesNestedImpl(-1, item);
  }
  public APIServerServingCertsFluentImpl.NamedCertificatesNested<A> setNewNamedCertificateLike(int index,APIServerNamedServingCert item) {
    return new APIServerServingCertsFluentImpl.NamedCertificatesNestedImpl(index, item);
  }
  public APIServerServingCertsFluentImpl.NamedCertificatesNested<A> editNamedCertificate(int index) {
    if (namedCertificates.size() <= index) throw new RuntimeException("Can't edit namedCertificates. Index exceeds size.");
    return setNewNamedCertificateLike(index, buildNamedCertificate(index));
  }
  public APIServerServingCertsFluentImpl.NamedCertificatesNested<A> editFirstNamedCertificate() {
    if (namedCertificates.size() == 0) throw new RuntimeException("Can't edit first namedCertificates. The list is empty.");
    return setNewNamedCertificateLike(0, buildNamedCertificate(0));
  }
  public APIServerServingCertsFluentImpl.NamedCertificatesNested<A> editLastNamedCertificate() {
    int index = namedCertificates.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last namedCertificates. The list is empty.");
    return setNewNamedCertificateLike(index, buildNamedCertificate(index));
  }
  public APIServerServingCertsFluentImpl.NamedCertificatesNested<A> editMatchingNamedCertificate(Predicate<APIServerNamedServingCertBuilder> predicate) {
    int index = -1;
    for (int i=0;i<namedCertificates.size();i++) { 
    if (predicate.test(namedCertificates.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching namedCertificates. No match found.");
    return setNewNamedCertificateLike(index, buildNamedCertificate(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    APIServerServingCertsFluentImpl that = (APIServerServingCertsFluentImpl) o;
    if (!java.util.Objects.equals(namedCertificates, that.namedCertificates)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(namedCertificates,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (namedCertificates != null) { sb.append("namedCertificates:"); sb.append(namedCertificates + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class NamedCertificatesNestedImpl<N> extends APIServerNamedServingCertFluentImpl<APIServerServingCertsFluentImpl.NamedCertificatesNested<N>> implements APIServerServingCertsFluentImpl.NamedCertificatesNested<N>,Nested<N>{
    NamedCertificatesNestedImpl(int index,APIServerNamedServingCert item) {
      this.index = index;
      this.builder = new APIServerNamedServingCertBuilder(this, item);
    }
    NamedCertificatesNestedImpl() {
      this.index = -1;
      this.builder = new APIServerNamedServingCertBuilder(this);
    }
    APIServerNamedServingCertBuilder builder;
    int index;
    public N and() {
      return (N) APIServerServingCertsFluentImpl.this.setToNamedCertificates(index,builder.build());
    }
    public N endNamedCertificate() {
      return and();
    }
    
  }
  
}