package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class APIServerStatusBuilder extends APIServerStatusFluentImpl<APIServerStatusBuilder> implements VisitableBuilder<APIServerStatus,APIServerStatusBuilder>{
  public APIServerStatusBuilder() {
    this(false);
  }
  public APIServerStatusBuilder(Boolean validationEnabled) {
    this(new APIServerStatus(), validationEnabled);
  }
  public APIServerStatusBuilder(APIServerStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public APIServerStatusBuilder(APIServerStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new APIServerStatus(), validationEnabled);
  }
  public APIServerStatusBuilder(APIServerStatusFluent<?> fluent,APIServerStatus instance) {
    this(fluent, instance, false);
  }
  public APIServerStatusBuilder(APIServerStatusFluent<?> fluent,APIServerStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public APIServerStatusBuilder(APIServerStatus instance) {
    this(instance,false);
  }
  public APIServerStatusBuilder(APIServerStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  APIServerStatusFluent<?> fluent;
  Boolean validationEnabled;
  public APIServerStatus build() {
    APIServerStatus buildable = new APIServerStatus();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}