package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class AWSPlatformSpecFluentImpl<A extends AWSPlatformSpecFluent<A>> extends BaseFluent<A> implements AWSPlatformSpecFluent<A>{
  public AWSPlatformSpecFluentImpl() {
  }
  public AWSPlatformSpecFluentImpl(AWSPlatformSpec instance) {
    if (instance != null) {
      this.withServiceEndpoints(instance.getServiceEndpoints());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ArrayList<AWSServiceEndpointBuilder> serviceEndpoints = new ArrayList<AWSServiceEndpointBuilder>();
  private Map<String,Object> additionalProperties;
  public A addToServiceEndpoints(int index,AWSServiceEndpoint item) {
    if (this.serviceEndpoints == null) {this.serviceEndpoints = new ArrayList<AWSServiceEndpointBuilder>();}
    AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);
    if (index < 0 || index >= serviceEndpoints.size()) { _visitables.get("serviceEndpoints").add(builder); serviceEndpoints.add(builder); } else { _visitables.get("serviceEndpoints").add(index, builder); serviceEndpoints.add(index, builder);}
    return (A)this;
  }
  public A setToServiceEndpoints(int index,AWSServiceEndpoint item) {
    if (this.serviceEndpoints == null) {this.serviceEndpoints = new ArrayList<AWSServiceEndpointBuilder>();}
    AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);
    if (index < 0 || index >= serviceEndpoints.size()) { _visitables.get("serviceEndpoints").add(builder); serviceEndpoints.add(builder); } else { _visitables.get("serviceEndpoints").set(index, builder); serviceEndpoints.set(index, builder);}
    return (A)this;
  }
  public A addToServiceEndpoints(io.fabric8.openshift.api.model.config.v1.AWSServiceEndpoint... items) {
    if (this.serviceEndpoints == null) {this.serviceEndpoints = new ArrayList<AWSServiceEndpointBuilder>();}
    for (AWSServiceEndpoint item : items) {AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").add(builder);this.serviceEndpoints.add(builder);} return (A)this;
  }
  public A addAllToServiceEndpoints(Collection<AWSServiceEndpoint> items) {
    if (this.serviceEndpoints == null) {this.serviceEndpoints = new ArrayList<AWSServiceEndpointBuilder>();}
    for (AWSServiceEndpoint item : items) {AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").add(builder);this.serviceEndpoints.add(builder);} return (A)this;
  }
  public A removeFromServiceEndpoints(io.fabric8.openshift.api.model.config.v1.AWSServiceEndpoint... items) {
    for (AWSServiceEndpoint item : items) {AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").remove(builder);if (this.serviceEndpoints != null) {this.serviceEndpoints.remove(builder);}} return (A)this;
  }
  public A removeAllFromServiceEndpoints(Collection<AWSServiceEndpoint> items) {
    for (AWSServiceEndpoint item : items) {AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").remove(builder);if (this.serviceEndpoints != null) {this.serviceEndpoints.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromServiceEndpoints(Predicate<AWSServiceEndpointBuilder> predicate) {
    if (serviceEndpoints == null) return (A) this;
    final Iterator<AWSServiceEndpointBuilder> each = serviceEndpoints.iterator();
    final List visitables = _visitables.get("serviceEndpoints");
    while (each.hasNext()) {
      AWSServiceEndpointBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildServiceEndpoints instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<AWSServiceEndpoint> getServiceEndpoints() {
    return serviceEndpoints != null ? build(serviceEndpoints) : null;
  }
  public List<AWSServiceEndpoint> buildServiceEndpoints() {
    return serviceEndpoints != null ? build(serviceEndpoints) : null;
  }
  public AWSServiceEndpoint buildServiceEndpoint(int index) {
    return this.serviceEndpoints.get(index).build();
  }
  public AWSServiceEndpoint buildFirstServiceEndpoint() {
    return this.serviceEndpoints.get(0).build();
  }
  public AWSServiceEndpoint buildLastServiceEndpoint() {
    return this.serviceEndpoints.get(serviceEndpoints.size() - 1).build();
  }
  public AWSServiceEndpoint buildMatchingServiceEndpoint(Predicate<AWSServiceEndpointBuilder> predicate) {
    for (AWSServiceEndpointBuilder item: serviceEndpoints) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingServiceEndpoint(Predicate<AWSServiceEndpointBuilder> predicate) {
    for (AWSServiceEndpointBuilder item: serviceEndpoints) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withServiceEndpoints(List<AWSServiceEndpoint> serviceEndpoints) {
    if (this.serviceEndpoints != null) { _visitables.get("serviceEndpoints").clear();}
    if (serviceEndpoints != null) {this.serviceEndpoints = new ArrayList(); for (AWSServiceEndpoint item : serviceEndpoints){this.addToServiceEndpoints(item);}} else { this.serviceEndpoints = null;} return (A) this;
  }
  public A withServiceEndpoints(io.fabric8.openshift.api.model.config.v1.AWSServiceEndpoint... serviceEndpoints) {
    if (this.serviceEndpoints != null) {this.serviceEndpoints.clear(); _visitables.remove("serviceEndpoints"); }
    if (serviceEndpoints != null) {for (AWSServiceEndpoint item :serviceEndpoints){ this.addToServiceEndpoints(item);}} return (A) this;
  }
  public Boolean hasServiceEndpoints() {
    return serviceEndpoints != null && !serviceEndpoints.isEmpty();
  }
  public A addNewServiceEndpoint(String name,String url) {
    return (A)addToServiceEndpoints(new AWSServiceEndpoint(name, url));
  }
  public AWSPlatformSpecFluentImpl.ServiceEndpointsNested<A> addNewServiceEndpoint() {
    return new AWSPlatformSpecFluentImpl.ServiceEndpointsNestedImpl();
  }
  public AWSPlatformSpecFluentImpl.ServiceEndpointsNested<A> addNewServiceEndpointLike(AWSServiceEndpoint item) {
    return new AWSPlatformSpecFluentImpl.ServiceEndpointsNestedImpl(-1, item);
  }
  public AWSPlatformSpecFluentImpl.ServiceEndpointsNested<A> setNewServiceEndpointLike(int index,AWSServiceEndpoint item) {
    return new AWSPlatformSpecFluentImpl.ServiceEndpointsNestedImpl(index, item);
  }
  public AWSPlatformSpecFluentImpl.ServiceEndpointsNested<A> editServiceEndpoint(int index) {
    if (serviceEndpoints.size() <= index) throw new RuntimeException("Can't edit serviceEndpoints. Index exceeds size.");
    return setNewServiceEndpointLike(index, buildServiceEndpoint(index));
  }
  public AWSPlatformSpecFluentImpl.ServiceEndpointsNested<A> editFirstServiceEndpoint() {
    if (serviceEndpoints.size() == 0) throw new RuntimeException("Can't edit first serviceEndpoints. The list is empty.");
    return setNewServiceEndpointLike(0, buildServiceEndpoint(0));
  }
  public AWSPlatformSpecFluentImpl.ServiceEndpointsNested<A> editLastServiceEndpoint() {
    int index = serviceEndpoints.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last serviceEndpoints. The list is empty.");
    return setNewServiceEndpointLike(index, buildServiceEndpoint(index));
  }
  public AWSPlatformSpecFluentImpl.ServiceEndpointsNested<A> editMatchingServiceEndpoint(Predicate<AWSServiceEndpointBuilder> predicate) {
    int index = -1;
    for (int i=0;i<serviceEndpoints.size();i++) { 
    if (predicate.test(serviceEndpoints.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching serviceEndpoints. No match found.");
    return setNewServiceEndpointLike(index, buildServiceEndpoint(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AWSPlatformSpecFluentImpl that = (AWSPlatformSpecFluentImpl) o;
    if (!java.util.Objects.equals(serviceEndpoints, that.serviceEndpoints)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(serviceEndpoints,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (serviceEndpoints != null) { sb.append("serviceEndpoints:"); sb.append(serviceEndpoints + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ServiceEndpointsNestedImpl<N> extends AWSServiceEndpointFluentImpl<AWSPlatformSpecFluentImpl.ServiceEndpointsNested<N>> implements AWSPlatformSpecFluentImpl.ServiceEndpointsNested<N>,Nested<N>{
    ServiceEndpointsNestedImpl(int index,AWSServiceEndpoint item) {
      this.index = index;
      this.builder = new AWSServiceEndpointBuilder(this, item);
    }
    ServiceEndpointsNestedImpl() {
      this.index = -1;
      this.builder = new AWSServiceEndpointBuilder(this);
    }
    AWSServiceEndpointBuilder builder;
    int index;
    public N and() {
      return (N) AWSPlatformSpecFluentImpl.this.setToServiceEndpoints(index,builder.build());
    }
    public N endServiceEndpoint() {
      return and();
    }
    
  }
  
}