package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class AlibabaCloudPlatformStatusFluentImpl<A extends AlibabaCloudPlatformStatusFluent<A>> extends BaseFluent<A> implements AlibabaCloudPlatformStatusFluent<A>{
  public AlibabaCloudPlatformStatusFluentImpl() {
  }
  public AlibabaCloudPlatformStatusFluentImpl(AlibabaCloudPlatformStatus instance) {
    if (instance != null) {
      this.withRegion(instance.getRegion());
      this.withResourceGroupID(instance.getResourceGroupID());
      this.withResourceTags(instance.getResourceTags());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String region;
  private String resourceGroupID;
  private ArrayList<AlibabaCloudResourceTagBuilder> resourceTags = new ArrayList<AlibabaCloudResourceTagBuilder>();
  private Map<String,Object> additionalProperties;
  public String getRegion() {
    return this.region;
  }
  public A withRegion(String region) {
    this.region=region; return (A) this;
  }
  public Boolean hasRegion() {
    return this.region != null;
  }
  public String getResourceGroupID() {
    return this.resourceGroupID;
  }
  public A withResourceGroupID(String resourceGroupID) {
    this.resourceGroupID=resourceGroupID; return (A) this;
  }
  public Boolean hasResourceGroupID() {
    return this.resourceGroupID != null;
  }
  public A addToResourceTags(int index,AlibabaCloudResourceTag item) {
    if (this.resourceTags == null) {this.resourceTags = new ArrayList<AlibabaCloudResourceTagBuilder>();}
    AlibabaCloudResourceTagBuilder builder = new AlibabaCloudResourceTagBuilder(item);
    if (index < 0 || index >= resourceTags.size()) { _visitables.get("resourceTags").add(builder); resourceTags.add(builder); } else { _visitables.get("resourceTags").add(index, builder); resourceTags.add(index, builder);}
    return (A)this;
  }
  public A setToResourceTags(int index,AlibabaCloudResourceTag item) {
    if (this.resourceTags == null) {this.resourceTags = new ArrayList<AlibabaCloudResourceTagBuilder>();}
    AlibabaCloudResourceTagBuilder builder = new AlibabaCloudResourceTagBuilder(item);
    if (index < 0 || index >= resourceTags.size()) { _visitables.get("resourceTags").add(builder); resourceTags.add(builder); } else { _visitables.get("resourceTags").set(index, builder); resourceTags.set(index, builder);}
    return (A)this;
  }
  public A addToResourceTags(io.fabric8.openshift.api.model.config.v1.AlibabaCloudResourceTag... items) {
    if (this.resourceTags == null) {this.resourceTags = new ArrayList<AlibabaCloudResourceTagBuilder>();}
    for (AlibabaCloudResourceTag item : items) {AlibabaCloudResourceTagBuilder builder = new AlibabaCloudResourceTagBuilder(item);_visitables.get("resourceTags").add(builder);this.resourceTags.add(builder);} return (A)this;
  }
  public A addAllToResourceTags(Collection<AlibabaCloudResourceTag> items) {
    if (this.resourceTags == null) {this.resourceTags = new ArrayList<AlibabaCloudResourceTagBuilder>();}
    for (AlibabaCloudResourceTag item : items) {AlibabaCloudResourceTagBuilder builder = new AlibabaCloudResourceTagBuilder(item);_visitables.get("resourceTags").add(builder);this.resourceTags.add(builder);} return (A)this;
  }
  public A removeFromResourceTags(io.fabric8.openshift.api.model.config.v1.AlibabaCloudResourceTag... items) {
    for (AlibabaCloudResourceTag item : items) {AlibabaCloudResourceTagBuilder builder = new AlibabaCloudResourceTagBuilder(item);_visitables.get("resourceTags").remove(builder);if (this.resourceTags != null) {this.resourceTags.remove(builder);}} return (A)this;
  }
  public A removeAllFromResourceTags(Collection<AlibabaCloudResourceTag> items) {
    for (AlibabaCloudResourceTag item : items) {AlibabaCloudResourceTagBuilder builder = new AlibabaCloudResourceTagBuilder(item);_visitables.get("resourceTags").remove(builder);if (this.resourceTags != null) {this.resourceTags.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromResourceTags(Predicate<AlibabaCloudResourceTagBuilder> predicate) {
    if (resourceTags == null) return (A) this;
    final Iterator<AlibabaCloudResourceTagBuilder> each = resourceTags.iterator();
    final List visitables = _visitables.get("resourceTags");
    while (each.hasNext()) {
      AlibabaCloudResourceTagBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildResourceTags instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<AlibabaCloudResourceTag> getResourceTags() {
    return resourceTags != null ? build(resourceTags) : null;
  }
  public List<AlibabaCloudResourceTag> buildResourceTags() {
    return resourceTags != null ? build(resourceTags) : null;
  }
  public AlibabaCloudResourceTag buildResourceTag(int index) {
    return this.resourceTags.get(index).build();
  }
  public AlibabaCloudResourceTag buildFirstResourceTag() {
    return this.resourceTags.get(0).build();
  }
  public AlibabaCloudResourceTag buildLastResourceTag() {
    return this.resourceTags.get(resourceTags.size() - 1).build();
  }
  public AlibabaCloudResourceTag buildMatchingResourceTag(Predicate<AlibabaCloudResourceTagBuilder> predicate) {
    for (AlibabaCloudResourceTagBuilder item: resourceTags) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingResourceTag(Predicate<AlibabaCloudResourceTagBuilder> predicate) {
    for (AlibabaCloudResourceTagBuilder item: resourceTags) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withResourceTags(List<AlibabaCloudResourceTag> resourceTags) {
    if (this.resourceTags != null) { _visitables.get("resourceTags").clear();}
    if (resourceTags != null) {this.resourceTags = new ArrayList(); for (AlibabaCloudResourceTag item : resourceTags){this.addToResourceTags(item);}} else { this.resourceTags = null;} return (A) this;
  }
  public A withResourceTags(io.fabric8.openshift.api.model.config.v1.AlibabaCloudResourceTag... resourceTags) {
    if (this.resourceTags != null) {this.resourceTags.clear(); _visitables.remove("resourceTags"); }
    if (resourceTags != null) {for (AlibabaCloudResourceTag item :resourceTags){ this.addToResourceTags(item);}} return (A) this;
  }
  public Boolean hasResourceTags() {
    return resourceTags != null && !resourceTags.isEmpty();
  }
  public A addNewResourceTag(String key,String value) {
    return (A)addToResourceTags(new AlibabaCloudResourceTag(key, value));
  }
  public AlibabaCloudPlatformStatusFluentImpl.ResourceTagsNested<A> addNewResourceTag() {
    return new AlibabaCloudPlatformStatusFluentImpl.ResourceTagsNestedImpl();
  }
  public AlibabaCloudPlatformStatusFluentImpl.ResourceTagsNested<A> addNewResourceTagLike(AlibabaCloudResourceTag item) {
    return new AlibabaCloudPlatformStatusFluentImpl.ResourceTagsNestedImpl(-1, item);
  }
  public AlibabaCloudPlatformStatusFluentImpl.ResourceTagsNested<A> setNewResourceTagLike(int index,AlibabaCloudResourceTag item) {
    return new AlibabaCloudPlatformStatusFluentImpl.ResourceTagsNestedImpl(index, item);
  }
  public AlibabaCloudPlatformStatusFluentImpl.ResourceTagsNested<A> editResourceTag(int index) {
    if (resourceTags.size() <= index) throw new RuntimeException("Can't edit resourceTags. Index exceeds size.");
    return setNewResourceTagLike(index, buildResourceTag(index));
  }
  public AlibabaCloudPlatformStatusFluentImpl.ResourceTagsNested<A> editFirstResourceTag() {
    if (resourceTags.size() == 0) throw new RuntimeException("Can't edit first resourceTags. The list is empty.");
    return setNewResourceTagLike(0, buildResourceTag(0));
  }
  public AlibabaCloudPlatformStatusFluentImpl.ResourceTagsNested<A> editLastResourceTag() {
    int index = resourceTags.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last resourceTags. The list is empty.");
    return setNewResourceTagLike(index, buildResourceTag(index));
  }
  public AlibabaCloudPlatformStatusFluentImpl.ResourceTagsNested<A> editMatchingResourceTag(Predicate<AlibabaCloudResourceTagBuilder> predicate) {
    int index = -1;
    for (int i=0;i<resourceTags.size();i++) { 
    if (predicate.test(resourceTags.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching resourceTags. No match found.");
    return setNewResourceTagLike(index, buildResourceTag(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AlibabaCloudPlatformStatusFluentImpl that = (AlibabaCloudPlatformStatusFluentImpl) o;
    if (!java.util.Objects.equals(region, that.region)) return false;

    if (!java.util.Objects.equals(resourceGroupID, that.resourceGroupID)) return false;

    if (!java.util.Objects.equals(resourceTags, that.resourceTags)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(region,  resourceGroupID,  resourceTags,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (region != null) { sb.append("region:"); sb.append(region + ","); }
    if (resourceGroupID != null) { sb.append("resourceGroupID:"); sb.append(resourceGroupID + ","); }
    if (resourceTags != null) { sb.append("resourceTags:"); sb.append(resourceTags + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ResourceTagsNestedImpl<N> extends AlibabaCloudResourceTagFluentImpl<AlibabaCloudPlatformStatusFluentImpl.ResourceTagsNested<N>> implements AlibabaCloudPlatformStatusFluentImpl.ResourceTagsNested<N>,Nested<N>{
    ResourceTagsNestedImpl(int index,AlibabaCloudResourceTag item) {
      this.index = index;
      this.builder = new AlibabaCloudResourceTagBuilder(this, item);
    }
    ResourceTagsNestedImpl() {
      this.index = -1;
      this.builder = new AlibabaCloudResourceTagBuilder(this);
    }
    AlibabaCloudResourceTagBuilder builder;
    int index;
    public N and() {
      return (N) AlibabaCloudPlatformStatusFluentImpl.this.setToResourceTags(index,builder.build());
    }
    public N endResourceTag() {
      return and();
    }
    
  }
  
}