package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterConditionBuilder extends ClusterConditionFluentImpl<ClusterConditionBuilder> implements VisitableBuilder<ClusterCondition,ClusterConditionBuilder>{
  public ClusterConditionBuilder() {
    this(false);
  }
  public ClusterConditionBuilder(Boolean validationEnabled) {
    this(new ClusterCondition(), validationEnabled);
  }
  public ClusterConditionBuilder(ClusterConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterConditionBuilder(ClusterConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterCondition(), validationEnabled);
  }
  public ClusterConditionBuilder(ClusterConditionFluent<?> fluent,ClusterCondition instance) {
    this(fluent, instance, false);
  }
  public ClusterConditionBuilder(ClusterConditionFluent<?> fluent,ClusterCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withPromql(instance.getPromql());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterConditionBuilder(ClusterCondition instance) {
    this(instance,false);
  }
  public ClusterConditionBuilder(ClusterCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withPromql(instance.getPromql());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterConditionFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterCondition build() {
    ClusterCondition buildable = new ClusterCondition(fluent.getPromql(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}