package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterOperatorStatusConditionBuilder extends ClusterOperatorStatusConditionFluentImpl<ClusterOperatorStatusConditionBuilder> implements VisitableBuilder<ClusterOperatorStatusCondition,ClusterOperatorStatusConditionBuilder>{
  public ClusterOperatorStatusConditionBuilder() {
    this(false);
  }
  public ClusterOperatorStatusConditionBuilder(Boolean validationEnabled) {
    this(new ClusterOperatorStatusCondition(), validationEnabled);
  }
  public ClusterOperatorStatusConditionBuilder(ClusterOperatorStatusConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterOperatorStatusConditionBuilder(ClusterOperatorStatusConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterOperatorStatusCondition(), validationEnabled);
  }
  public ClusterOperatorStatusConditionBuilder(ClusterOperatorStatusConditionFluent<?> fluent,ClusterOperatorStatusCondition instance) {
    this(fluent, instance, false);
  }
  public ClusterOperatorStatusConditionBuilder(ClusterOperatorStatusConditionFluent<?> fluent,ClusterOperatorStatusCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterOperatorStatusConditionBuilder(ClusterOperatorStatusCondition instance) {
    this(instance,false);
  }
  public ClusterOperatorStatusConditionBuilder(ClusterOperatorStatusCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterOperatorStatusConditionFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterOperatorStatusCondition build() {
    ClusterOperatorStatusCondition buildable = new ClusterOperatorStatusCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}