package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterVersionBuilder extends ClusterVersionFluentImpl<ClusterVersionBuilder> implements VisitableBuilder<ClusterVersion,ClusterVersionBuilder>{
  public ClusterVersionBuilder() {
    this(false);
  }
  public ClusterVersionBuilder(Boolean validationEnabled) {
    this(new ClusterVersion(), validationEnabled);
  }
  public ClusterVersionBuilder(ClusterVersionFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterVersionBuilder(ClusterVersionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterVersion(), validationEnabled);
  }
  public ClusterVersionBuilder(ClusterVersionFluent<?> fluent,ClusterVersion instance) {
    this(fluent, instance, false);
  }
  public ClusterVersionBuilder(ClusterVersionFluent<?> fluent,ClusterVersion instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterVersionBuilder(ClusterVersion instance) {
    this(instance,false);
  }
  public ClusterVersionBuilder(ClusterVersion instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterVersionFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterVersion build() {
    ClusterVersion buildable = new ClusterVersion(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}