package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ClusterVersionSpecFluentImpl<A extends ClusterVersionSpecFluent<A>> extends BaseFluent<A> implements ClusterVersionSpecFluent<A>{
  public ClusterVersionSpecFluentImpl() {
  }
  public ClusterVersionSpecFluentImpl(ClusterVersionSpec instance) {
    if (instance != null) {
      this.withChannel(instance.getChannel());
      this.withClusterID(instance.getClusterID());
      this.withDesiredUpdate(instance.getDesiredUpdate());
      this.withOverrides(instance.getOverrides());
      this.withUpstream(instance.getUpstream());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String channel;
  private String clusterID;
  private UpdateBuilder desiredUpdate;
  private ArrayList<ComponentOverrideBuilder> overrides = new ArrayList<ComponentOverrideBuilder>();
  private String upstream;
  private Map<String,Object> additionalProperties;
  public String getChannel() {
    return this.channel;
  }
  public A withChannel(String channel) {
    this.channel=channel; return (A) this;
  }
  public Boolean hasChannel() {
    return this.channel != null;
  }
  public String getClusterID() {
    return this.clusterID;
  }
  public A withClusterID(String clusterID) {
    this.clusterID=clusterID; return (A) this;
  }
  public Boolean hasClusterID() {
    return this.clusterID != null;
  }
  
  /**
   * This method has been deprecated, please use method buildDesiredUpdate instead.
   * @return The buildable object.
   */
  @Deprecated
  public Update getDesiredUpdate() {
    return this.desiredUpdate!=null ?this.desiredUpdate.build():null;
  }
  public Update buildDesiredUpdate() {
    return this.desiredUpdate!=null ?this.desiredUpdate.build():null;
  }
  public A withDesiredUpdate(Update desiredUpdate) {
    _visitables.get("desiredUpdate").remove(this.desiredUpdate);
    if (desiredUpdate!=null){ this.desiredUpdate= new UpdateBuilder(desiredUpdate); _visitables.get("desiredUpdate").add(this.desiredUpdate);} else { this.desiredUpdate = null; _visitables.get("desiredUpdate").remove(this.desiredUpdate); } return (A) this;
  }
  public Boolean hasDesiredUpdate() {
    return this.desiredUpdate != null;
  }
  public A withNewDesiredUpdate(Boolean force,String image,String version) {
    return (A)withDesiredUpdate(new Update(force, image, version));
  }
  public ClusterVersionSpecFluentImpl.DesiredUpdateNested<A> withNewDesiredUpdate() {
    return new ClusterVersionSpecFluentImpl.DesiredUpdateNestedImpl();
  }
  public ClusterVersionSpecFluentImpl.DesiredUpdateNested<A> withNewDesiredUpdateLike(Update item) {
    return new ClusterVersionSpecFluentImpl.DesiredUpdateNestedImpl(item);
  }
  public ClusterVersionSpecFluentImpl.DesiredUpdateNested<A> editDesiredUpdate() {
    return withNewDesiredUpdateLike(getDesiredUpdate());
  }
  public ClusterVersionSpecFluentImpl.DesiredUpdateNested<A> editOrNewDesiredUpdate() {
    return withNewDesiredUpdateLike(getDesiredUpdate() != null ? getDesiredUpdate(): new UpdateBuilder().build());
  }
  public ClusterVersionSpecFluentImpl.DesiredUpdateNested<A> editOrNewDesiredUpdateLike(Update item) {
    return withNewDesiredUpdateLike(getDesiredUpdate() != null ? getDesiredUpdate(): item);
  }
  public A addToOverrides(int index,ComponentOverride item) {
    if (this.overrides == null) {this.overrides = new ArrayList<ComponentOverrideBuilder>();}
    ComponentOverrideBuilder builder = new ComponentOverrideBuilder(item);
    if (index < 0 || index >= overrides.size()) { _visitables.get("overrides").add(builder); overrides.add(builder); } else { _visitables.get("overrides").add(index, builder); overrides.add(index, builder);}
    return (A)this;
  }
  public A setToOverrides(int index,ComponentOverride item) {
    if (this.overrides == null) {this.overrides = new ArrayList<ComponentOverrideBuilder>();}
    ComponentOverrideBuilder builder = new ComponentOverrideBuilder(item);
    if (index < 0 || index >= overrides.size()) { _visitables.get("overrides").add(builder); overrides.add(builder); } else { _visitables.get("overrides").set(index, builder); overrides.set(index, builder);}
    return (A)this;
  }
  public A addToOverrides(io.fabric8.openshift.api.model.config.v1.ComponentOverride... items) {
    if (this.overrides == null) {this.overrides = new ArrayList<ComponentOverrideBuilder>();}
    for (ComponentOverride item : items) {ComponentOverrideBuilder builder = new ComponentOverrideBuilder(item);_visitables.get("overrides").add(builder);this.overrides.add(builder);} return (A)this;
  }
  public A addAllToOverrides(Collection<ComponentOverride> items) {
    if (this.overrides == null) {this.overrides = new ArrayList<ComponentOverrideBuilder>();}
    for (ComponentOverride item : items) {ComponentOverrideBuilder builder = new ComponentOverrideBuilder(item);_visitables.get("overrides").add(builder);this.overrides.add(builder);} return (A)this;
  }
  public A removeFromOverrides(io.fabric8.openshift.api.model.config.v1.ComponentOverride... items) {
    for (ComponentOverride item : items) {ComponentOverrideBuilder builder = new ComponentOverrideBuilder(item);_visitables.get("overrides").remove(builder);if (this.overrides != null) {this.overrides.remove(builder);}} return (A)this;
  }
  public A removeAllFromOverrides(Collection<ComponentOverride> items) {
    for (ComponentOverride item : items) {ComponentOverrideBuilder builder = new ComponentOverrideBuilder(item);_visitables.get("overrides").remove(builder);if (this.overrides != null) {this.overrides.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromOverrides(Predicate<ComponentOverrideBuilder> predicate) {
    if (overrides == null) return (A) this;
    final Iterator<ComponentOverrideBuilder> each = overrides.iterator();
    final List visitables = _visitables.get("overrides");
    while (each.hasNext()) {
      ComponentOverrideBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildOverrides instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ComponentOverride> getOverrides() {
    return overrides != null ? build(overrides) : null;
  }
  public List<ComponentOverride> buildOverrides() {
    return overrides != null ? build(overrides) : null;
  }
  public ComponentOverride buildOverride(int index) {
    return this.overrides.get(index).build();
  }
  public ComponentOverride buildFirstOverride() {
    return this.overrides.get(0).build();
  }
  public ComponentOverride buildLastOverride() {
    return this.overrides.get(overrides.size() - 1).build();
  }
  public ComponentOverride buildMatchingOverride(Predicate<ComponentOverrideBuilder> predicate) {
    for (ComponentOverrideBuilder item: overrides) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingOverride(Predicate<ComponentOverrideBuilder> predicate) {
    for (ComponentOverrideBuilder item: overrides) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withOverrides(List<ComponentOverride> overrides) {
    if (this.overrides != null) { _visitables.get("overrides").clear();}
    if (overrides != null) {this.overrides = new ArrayList(); for (ComponentOverride item : overrides){this.addToOverrides(item);}} else { this.overrides = null;} return (A) this;
  }
  public A withOverrides(io.fabric8.openshift.api.model.config.v1.ComponentOverride... overrides) {
    if (this.overrides != null) {this.overrides.clear(); _visitables.remove("overrides"); }
    if (overrides != null) {for (ComponentOverride item :overrides){ this.addToOverrides(item);}} return (A) this;
  }
  public Boolean hasOverrides() {
    return overrides != null && !overrides.isEmpty();
  }
  public A addNewOverride(String group,String kind,String name,String namespace,Boolean unmanaged) {
    return (A)addToOverrides(new ComponentOverride(group, kind, name, namespace, unmanaged));
  }
  public ClusterVersionSpecFluentImpl.OverridesNested<A> addNewOverride() {
    return new ClusterVersionSpecFluentImpl.OverridesNestedImpl();
  }
  public ClusterVersionSpecFluentImpl.OverridesNested<A> addNewOverrideLike(ComponentOverride item) {
    return new ClusterVersionSpecFluentImpl.OverridesNestedImpl(-1, item);
  }
  public ClusterVersionSpecFluentImpl.OverridesNested<A> setNewOverrideLike(int index,ComponentOverride item) {
    return new ClusterVersionSpecFluentImpl.OverridesNestedImpl(index, item);
  }
  public ClusterVersionSpecFluentImpl.OverridesNested<A> editOverride(int index) {
    if (overrides.size() <= index) throw new RuntimeException("Can't edit overrides. Index exceeds size.");
    return setNewOverrideLike(index, buildOverride(index));
  }
  public ClusterVersionSpecFluentImpl.OverridesNested<A> editFirstOverride() {
    if (overrides.size() == 0) throw new RuntimeException("Can't edit first overrides. The list is empty.");
    return setNewOverrideLike(0, buildOverride(0));
  }
  public ClusterVersionSpecFluentImpl.OverridesNested<A> editLastOverride() {
    int index = overrides.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last overrides. The list is empty.");
    return setNewOverrideLike(index, buildOverride(index));
  }
  public ClusterVersionSpecFluentImpl.OverridesNested<A> editMatchingOverride(Predicate<ComponentOverrideBuilder> predicate) {
    int index = -1;
    for (int i=0;i<overrides.size();i++) { 
    if (predicate.test(overrides.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching overrides. No match found.");
    return setNewOverrideLike(index, buildOverride(index));
  }
  public String getUpstream() {
    return this.upstream;
  }
  public A withUpstream(String upstream) {
    this.upstream=upstream; return (A) this;
  }
  public Boolean hasUpstream() {
    return this.upstream != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterVersionSpecFluentImpl that = (ClusterVersionSpecFluentImpl) o;
    if (!java.util.Objects.equals(channel, that.channel)) return false;

    if (!java.util.Objects.equals(clusterID, that.clusterID)) return false;

    if (!java.util.Objects.equals(desiredUpdate, that.desiredUpdate)) return false;

    if (!java.util.Objects.equals(overrides, that.overrides)) return false;

    if (!java.util.Objects.equals(upstream, that.upstream)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(channel,  clusterID,  desiredUpdate,  overrides,  upstream,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (channel != null) { sb.append("channel:"); sb.append(channel + ","); }
    if (clusterID != null) { sb.append("clusterID:"); sb.append(clusterID + ","); }
    if (desiredUpdate != null) { sb.append("desiredUpdate:"); sb.append(desiredUpdate + ","); }
    if (overrides != null) { sb.append("overrides:"); sb.append(overrides + ","); }
    if (upstream != null) { sb.append("upstream:"); sb.append(upstream + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class DesiredUpdateNestedImpl<N> extends UpdateFluentImpl<ClusterVersionSpecFluentImpl.DesiredUpdateNested<N>> implements ClusterVersionSpecFluentImpl.DesiredUpdateNested<N>,Nested<N>{
    DesiredUpdateNestedImpl(Update item) {
      this.builder = new UpdateBuilder(this, item);
    }
    DesiredUpdateNestedImpl() {
      this.builder = new UpdateBuilder(this);
    }
    UpdateBuilder builder;
    public N and() {
      return (N) ClusterVersionSpecFluentImpl.this.withDesiredUpdate(builder.build());
    }
    public N endDesiredUpdate() {
      return and();
    }
    
  }
  class OverridesNestedImpl<N> extends ComponentOverrideFluentImpl<ClusterVersionSpecFluentImpl.OverridesNested<N>> implements ClusterVersionSpecFluentImpl.OverridesNested<N>,Nested<N>{
    OverridesNestedImpl(int index,ComponentOverride item) {
      this.index = index;
      this.builder = new ComponentOverrideBuilder(this, item);
    }
    OverridesNestedImpl() {
      this.index = -1;
      this.builder = new ComponentOverrideBuilder(this);
    }
    ComponentOverrideBuilder builder;
    int index;
    public N and() {
      return (N) ClusterVersionSpecFluentImpl.this.setToOverrides(index,builder.build());
    }
    public N endOverride() {
      return and();
    }
    
  }
  
}