package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public interface ClusterVersionStatusFluent<A extends ClusterVersionStatusFluent<A>> extends Fluent<A>{
  public A addToAvailableUpdates(int index,Release item);
  public A setToAvailableUpdates(int index,Release item);
  public A addToAvailableUpdates(io.fabric8.openshift.api.model.config.v1.Release... items);
  public A addAllToAvailableUpdates(Collection<Release> items);
  public A removeFromAvailableUpdates(io.fabric8.openshift.api.model.config.v1.Release... items);
  public A removeAllFromAvailableUpdates(Collection<Release> items);
  public A removeMatchingFromAvailableUpdates(Predicate<ReleaseBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildAvailableUpdates instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Release> getAvailableUpdates();
  public List<Release> buildAvailableUpdates();
  public Release buildAvailableUpdate(int index);
  public Release buildFirstAvailableUpdate();
  public Release buildLastAvailableUpdate();
  public Release buildMatchingAvailableUpdate(Predicate<ReleaseBuilder> predicate);
  public Boolean hasMatchingAvailableUpdate(Predicate<ReleaseBuilder> predicate);
  public A withAvailableUpdates(List<Release> availableUpdates);
  public A withAvailableUpdates(io.fabric8.openshift.api.model.config.v1.Release... availableUpdates);
  public Boolean hasAvailableUpdates();
  public ClusterVersionStatusFluent.AvailableUpdatesNested<A> addNewAvailableUpdate();
  public ClusterVersionStatusFluent.AvailableUpdatesNested<A> addNewAvailableUpdateLike(Release item);
  public ClusterVersionStatusFluent.AvailableUpdatesNested<A> setNewAvailableUpdateLike(int index,Release item);
  public ClusterVersionStatusFluent.AvailableUpdatesNested<A> editAvailableUpdate(int index);
  public ClusterVersionStatusFluent.AvailableUpdatesNested<A> editFirstAvailableUpdate();
  public ClusterVersionStatusFluent.AvailableUpdatesNested<A> editLastAvailableUpdate();
  public ClusterVersionStatusFluent.AvailableUpdatesNested<A> editMatchingAvailableUpdate(Predicate<ReleaseBuilder> predicate);
  public A addToConditionalUpdates(int index,ConditionalUpdate item);
  public A setToConditionalUpdates(int index,ConditionalUpdate item);
  public A addToConditionalUpdates(io.fabric8.openshift.api.model.config.v1.ConditionalUpdate... items);
  public A addAllToConditionalUpdates(Collection<ConditionalUpdate> items);
  public A removeFromConditionalUpdates(io.fabric8.openshift.api.model.config.v1.ConditionalUpdate... items);
  public A removeAllFromConditionalUpdates(Collection<ConditionalUpdate> items);
  public A removeMatchingFromConditionalUpdates(Predicate<ConditionalUpdateBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildConditionalUpdates instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ConditionalUpdate> getConditionalUpdates();
  public List<ConditionalUpdate> buildConditionalUpdates();
  public ConditionalUpdate buildConditionalUpdate(int index);
  public ConditionalUpdate buildFirstConditionalUpdate();
  public ConditionalUpdate buildLastConditionalUpdate();
  public ConditionalUpdate buildMatchingConditionalUpdate(Predicate<ConditionalUpdateBuilder> predicate);
  public Boolean hasMatchingConditionalUpdate(Predicate<ConditionalUpdateBuilder> predicate);
  public A withConditionalUpdates(List<ConditionalUpdate> conditionalUpdates);
  public A withConditionalUpdates(io.fabric8.openshift.api.model.config.v1.ConditionalUpdate... conditionalUpdates);
  public Boolean hasConditionalUpdates();
  public ClusterVersionStatusFluent.ConditionalUpdatesNested<A> addNewConditionalUpdate();
  public ClusterVersionStatusFluent.ConditionalUpdatesNested<A> addNewConditionalUpdateLike(ConditionalUpdate item);
  public ClusterVersionStatusFluent.ConditionalUpdatesNested<A> setNewConditionalUpdateLike(int index,ConditionalUpdate item);
  public ClusterVersionStatusFluent.ConditionalUpdatesNested<A> editConditionalUpdate(int index);
  public ClusterVersionStatusFluent.ConditionalUpdatesNested<A> editFirstConditionalUpdate();
  public ClusterVersionStatusFluent.ConditionalUpdatesNested<A> editLastConditionalUpdate();
  public ClusterVersionStatusFluent.ConditionalUpdatesNested<A> editMatchingConditionalUpdate(Predicate<ConditionalUpdateBuilder> predicate);
  public A addToConditions(int index,ClusterOperatorStatusCondition item);
  public A setToConditions(int index,ClusterOperatorStatusCondition item);
  public A addToConditions(io.fabric8.openshift.api.model.config.v1.ClusterOperatorStatusCondition... items);
  public A addAllToConditions(Collection<ClusterOperatorStatusCondition> items);
  public A removeFromConditions(io.fabric8.openshift.api.model.config.v1.ClusterOperatorStatusCondition... items);
  public A removeAllFromConditions(Collection<ClusterOperatorStatusCondition> items);
  public A removeMatchingFromConditions(Predicate<ClusterOperatorStatusConditionBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ClusterOperatorStatusCondition> getConditions();
  public List<ClusterOperatorStatusCondition> buildConditions();
  public ClusterOperatorStatusCondition buildCondition(int index);
  public ClusterOperatorStatusCondition buildFirstCondition();
  public ClusterOperatorStatusCondition buildLastCondition();
  public ClusterOperatorStatusCondition buildMatchingCondition(Predicate<ClusterOperatorStatusConditionBuilder> predicate);
  public Boolean hasMatchingCondition(Predicate<ClusterOperatorStatusConditionBuilder> predicate);
  public A withConditions(List<ClusterOperatorStatusCondition> conditions);
  public A withConditions(io.fabric8.openshift.api.model.config.v1.ClusterOperatorStatusCondition... conditions);
  public Boolean hasConditions();
  public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type);
  public ClusterVersionStatusFluent.ConditionsNested<A> addNewCondition();
  public ClusterVersionStatusFluent.ConditionsNested<A> addNewConditionLike(ClusterOperatorStatusCondition item);
  public ClusterVersionStatusFluent.ConditionsNested<A> setNewConditionLike(int index,ClusterOperatorStatusCondition item);
  public ClusterVersionStatusFluent.ConditionsNested<A> editCondition(int index);
  public ClusterVersionStatusFluent.ConditionsNested<A> editFirstCondition();
  public ClusterVersionStatusFluent.ConditionsNested<A> editLastCondition();
  public ClusterVersionStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ClusterOperatorStatusConditionBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildDesired instead.
   * @return The buildable object.
   */
  @Deprecated
  public Release getDesired();
  public Release buildDesired();
  public A withDesired(Release desired);
  public Boolean hasDesired();
  public ClusterVersionStatusFluent.DesiredNested<A> withNewDesired();
  public ClusterVersionStatusFluent.DesiredNested<A> withNewDesiredLike(Release item);
  public ClusterVersionStatusFluent.DesiredNested<A> editDesired();
  public ClusterVersionStatusFluent.DesiredNested<A> editOrNewDesired();
  public ClusterVersionStatusFluent.DesiredNested<A> editOrNewDesiredLike(Release item);
  public A addToHistory(int index,UpdateHistory item);
  public A setToHistory(int index,UpdateHistory item);
  public A addToHistory(io.fabric8.openshift.api.model.config.v1.UpdateHistory... items);
  public A addAllToHistory(Collection<UpdateHistory> items);
  public A removeFromHistory(io.fabric8.openshift.api.model.config.v1.UpdateHistory... items);
  public A removeAllFromHistory(Collection<UpdateHistory> items);
  public A removeMatchingFromHistory(Predicate<UpdateHistoryBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildHistory instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<UpdateHistory> getHistory();
  public List<UpdateHistory> buildHistory();
  public UpdateHistory buildHistory(int index);
  public UpdateHistory buildFirstHistory();
  public UpdateHistory buildLastHistory();
  public UpdateHistory buildMatchingHistory(Predicate<UpdateHistoryBuilder> predicate);
  public Boolean hasMatchingHistory(Predicate<UpdateHistoryBuilder> predicate);
  public A withHistory(List<UpdateHistory> history);
  public A withHistory(io.fabric8.openshift.api.model.config.v1.UpdateHistory... history);
  public Boolean hasHistory();
  public ClusterVersionStatusFluent.HistoryNested<A> addNewHistory();
  public ClusterVersionStatusFluent.HistoryNested<A> addNewHistoryLike(UpdateHistory item);
  public ClusterVersionStatusFluent.HistoryNested<A> setNewHistoryLike(int index,UpdateHistory item);
  public ClusterVersionStatusFluent.HistoryNested<A> editHistory(int index);
  public ClusterVersionStatusFluent.HistoryNested<A> editFirstHistory();
  public ClusterVersionStatusFluent.HistoryNested<A> editLastHistory();
  public ClusterVersionStatusFluent.HistoryNested<A> editMatchingHistory(Predicate<UpdateHistoryBuilder> predicate);
  public Long getObservedGeneration();
  public A withObservedGeneration(Long observedGeneration);
  public Boolean hasObservedGeneration();
  public String getVersionHash();
  public A withVersionHash(String versionHash);
  public Boolean hasVersionHash();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface AvailableUpdatesNested<N> extends Nested<N>,ReleaseFluent<ClusterVersionStatusFluent.AvailableUpdatesNested<N>>{
    public N and();
    public N endAvailableUpdate();
    
  }
  public interface ConditionalUpdatesNested<N> extends Nested<N>,ConditionalUpdateFluent<ClusterVersionStatusFluent.ConditionalUpdatesNested<N>>{
    public N and();
    public N endConditionalUpdate();
    
  }
  public interface ConditionsNested<N> extends Nested<N>,ClusterOperatorStatusConditionFluent<ClusterVersionStatusFluent.ConditionsNested<N>>{
    public N and();
    public N endCondition();
    
  }
  public interface DesiredNested<N> extends Nested<N>,ReleaseFluent<ClusterVersionStatusFluent.DesiredNested<N>>{
    public N and();
    public N endDesired();
    
  }
  public interface HistoryNested<N> extends Nested<N>,UpdateHistoryFluent<ClusterVersionStatusFluent.HistoryNested<N>>{
    public N and();
    public N endHistory();
    
  }
  
}