package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DNSListBuilder extends DNSListFluentImpl<DNSListBuilder> implements VisitableBuilder<DNSList,DNSListBuilder>{
  public DNSListBuilder() {
    this(false);
  }
  public DNSListBuilder(Boolean validationEnabled) {
    this(new DNSList(), validationEnabled);
  }
  public DNSListBuilder(DNSListFluent<?> fluent) {
    this(fluent, false);
  }
  public DNSListBuilder(DNSListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DNSList(), validationEnabled);
  }
  public DNSListBuilder(DNSListFluent<?> fluent,DNSList instance) {
    this(fluent, instance, false);
  }
  public DNSListBuilder(DNSListFluent<?> fluent,DNSList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DNSListBuilder(DNSList instance) {
    this(instance,false);
  }
  public DNSListBuilder(DNSList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DNSListFluent<?> fluent;
  Boolean validationEnabled;
  public DNSList build() {
    DNSList buildable = new DNSList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}