package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ExternalIPConfigBuilder extends ExternalIPConfigFluentImpl<ExternalIPConfigBuilder> implements VisitableBuilder<ExternalIPConfig,ExternalIPConfigBuilder>{
  public ExternalIPConfigBuilder() {
    this(false);
  }
  public ExternalIPConfigBuilder(Boolean validationEnabled) {
    this(new ExternalIPConfig(), validationEnabled);
  }
  public ExternalIPConfigBuilder(ExternalIPConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public ExternalIPConfigBuilder(ExternalIPConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ExternalIPConfig(), validationEnabled);
  }
  public ExternalIPConfigBuilder(ExternalIPConfigFluent<?> fluent,ExternalIPConfig instance) {
    this(fluent, instance, false);
  }
  public ExternalIPConfigBuilder(ExternalIPConfigFluent<?> fluent,ExternalIPConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAutoAssignCIDRs(instance.getAutoAssignCIDRs());
      fluent.withPolicy(instance.getPolicy());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ExternalIPConfigBuilder(ExternalIPConfig instance) {
    this(instance,false);
  }
  public ExternalIPConfigBuilder(ExternalIPConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAutoAssignCIDRs(instance.getAutoAssignCIDRs());
      this.withPolicy(instance.getPolicy());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ExternalIPConfigFluent<?> fluent;
  Boolean validationEnabled;
  public ExternalIPConfig build() {
    ExternalIPConfig buildable = new ExternalIPConfig(fluent.getAutoAssignCIDRs(),fluent.getPolicy());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}