package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class FeatureGateStatusBuilder extends FeatureGateStatusFluentImpl<FeatureGateStatusBuilder> implements VisitableBuilder<FeatureGateStatus,FeatureGateStatusBuilder>{
  public FeatureGateStatusBuilder() {
    this(false);
  }
  public FeatureGateStatusBuilder(Boolean validationEnabled) {
    this(new FeatureGateStatus(), validationEnabled);
  }
  public FeatureGateStatusBuilder(FeatureGateStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public FeatureGateStatusBuilder(FeatureGateStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new FeatureGateStatus(), validationEnabled);
  }
  public FeatureGateStatusBuilder(FeatureGateStatusFluent<?> fluent,FeatureGateStatus instance) {
    this(fluent, instance, false);
  }
  public FeatureGateStatusBuilder(FeatureGateStatusFluent<?> fluent,FeatureGateStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public FeatureGateStatusBuilder(FeatureGateStatus instance) {
    this(instance,false);
  }
  public FeatureGateStatusBuilder(FeatureGateStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  FeatureGateStatusFluent<?> fluent;
  Boolean validationEnabled;
  public FeatureGateStatus build() {
    FeatureGateStatus buildable = new FeatureGateStatus();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}