package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HubSourceBuilder extends HubSourceFluentImpl<HubSourceBuilder> implements VisitableBuilder<HubSource,HubSourceBuilder>{
  public HubSourceBuilder() {
    this(false);
  }
  public HubSourceBuilder(Boolean validationEnabled) {
    this(new HubSource(), validationEnabled);
  }
  public HubSourceBuilder(HubSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public HubSourceBuilder(HubSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HubSource(), validationEnabled);
  }
  public HubSourceBuilder(HubSourceFluent<?> fluent,HubSource instance) {
    this(fluent, instance, false);
  }
  public HubSourceBuilder(HubSourceFluent<?> fluent,HubSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withDisabled(instance.getDisabled());
      fluent.withName(instance.getName());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public HubSourceBuilder(HubSource instance) {
    this(instance,false);
  }
  public HubSourceBuilder(HubSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withDisabled(instance.getDisabled());
      this.withName(instance.getName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  HubSourceFluent<?> fluent;
  Boolean validationEnabled;
  public HubSource build() {
    HubSource buildable = new HubSource(fluent.getDisabled(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}