package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IBMCloudPlatformStatusBuilder extends IBMCloudPlatformStatusFluentImpl<IBMCloudPlatformStatusBuilder> implements VisitableBuilder<IBMCloudPlatformStatus,IBMCloudPlatformStatusBuilder>{
  public IBMCloudPlatformStatusBuilder() {
    this(false);
  }
  public IBMCloudPlatformStatusBuilder(Boolean validationEnabled) {
    this(new IBMCloudPlatformStatus(), validationEnabled);
  }
  public IBMCloudPlatformStatusBuilder(IBMCloudPlatformStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public IBMCloudPlatformStatusBuilder(IBMCloudPlatformStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IBMCloudPlatformStatus(), validationEnabled);
  }
  public IBMCloudPlatformStatusBuilder(IBMCloudPlatformStatusFluent<?> fluent,IBMCloudPlatformStatus instance) {
    this(fluent, instance, false);
  }
  public IBMCloudPlatformStatusBuilder(IBMCloudPlatformStatusFluent<?> fluent,IBMCloudPlatformStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withCisInstanceCRN(instance.getCisInstanceCRN());
      fluent.withLocation(instance.getLocation());
      fluent.withProviderType(instance.getProviderType());
      fluent.withResourceGroupName(instance.getResourceGroupName());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public IBMCloudPlatformStatusBuilder(IBMCloudPlatformStatus instance) {
    this(instance,false);
  }
  public IBMCloudPlatformStatusBuilder(IBMCloudPlatformStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withCisInstanceCRN(instance.getCisInstanceCRN());
      this.withLocation(instance.getLocation());
      this.withProviderType(instance.getProviderType());
      this.withResourceGroupName(instance.getResourceGroupName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  IBMCloudPlatformStatusFluent<?> fluent;
  Boolean validationEnabled;
  public IBMCloudPlatformStatus build() {
    IBMCloudPlatformStatus buildable = new IBMCloudPlatformStatus(fluent.getCisInstanceCRN(),fluent.getLocation(),fluent.getProviderType(),fluent.getResourceGroupName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}