package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageListBuilder extends ImageListFluentImpl<ImageListBuilder> implements VisitableBuilder<ImageList,ImageListBuilder>{
  public ImageListBuilder() {
    this(false);
  }
  public ImageListBuilder(Boolean validationEnabled) {
    this(new ImageList(), validationEnabled);
  }
  public ImageListBuilder(ImageListFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageListBuilder(ImageListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageList(), validationEnabled);
  }
  public ImageListBuilder(ImageListFluent<?> fluent,ImageList instance) {
    this(fluent, instance, false);
  }
  public ImageListBuilder(ImageListFluent<?> fluent,ImageList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ImageListBuilder(ImageList instance) {
    this(instance,false);
  }
  public ImageListBuilder(ImageList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ImageListFluent<?> fluent;
  Boolean validationEnabled;
  public ImageList build() {
    ImageList buildable = new ImageList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}