package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class IngressSpecFluentImpl<A extends IngressSpecFluent<A>> extends BaseFluent<A> implements IngressSpecFluent<A>{
  public IngressSpecFluentImpl() {
  }
  public IngressSpecFluentImpl(IngressSpec instance) {
    if (instance != null) {
      this.withAppsDomain(instance.getAppsDomain());
      this.withComponentRoutes(instance.getComponentRoutes());
      this.withDomain(instance.getDomain());
      this.withRequiredHSTSPolicies(instance.getRequiredHSTSPolicies());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String appsDomain;
  private ArrayList<ComponentRouteSpecBuilder> componentRoutes = new ArrayList<ComponentRouteSpecBuilder>();
  private String domain;
  private ArrayList<RequiredHSTSPolicyBuilder> requiredHSTSPolicies = new ArrayList<RequiredHSTSPolicyBuilder>();
  private Map<String,Object> additionalProperties;
  public String getAppsDomain() {
    return this.appsDomain;
  }
  public A withAppsDomain(String appsDomain) {
    this.appsDomain=appsDomain; return (A) this;
  }
  public Boolean hasAppsDomain() {
    return this.appsDomain != null;
  }
  public A addToComponentRoutes(int index,ComponentRouteSpec item) {
    if (this.componentRoutes == null) {this.componentRoutes = new ArrayList<ComponentRouteSpecBuilder>();}
    ComponentRouteSpecBuilder builder = new ComponentRouteSpecBuilder(item);
    if (index < 0 || index >= componentRoutes.size()) { _visitables.get("componentRoutes").add(builder); componentRoutes.add(builder); } else { _visitables.get("componentRoutes").add(index, builder); componentRoutes.add(index, builder);}
    return (A)this;
  }
  public A setToComponentRoutes(int index,ComponentRouteSpec item) {
    if (this.componentRoutes == null) {this.componentRoutes = new ArrayList<ComponentRouteSpecBuilder>();}
    ComponentRouteSpecBuilder builder = new ComponentRouteSpecBuilder(item);
    if (index < 0 || index >= componentRoutes.size()) { _visitables.get("componentRoutes").add(builder); componentRoutes.add(builder); } else { _visitables.get("componentRoutes").set(index, builder); componentRoutes.set(index, builder);}
    return (A)this;
  }
  public A addToComponentRoutes(io.fabric8.openshift.api.model.config.v1.ComponentRouteSpec... items) {
    if (this.componentRoutes == null) {this.componentRoutes = new ArrayList<ComponentRouteSpecBuilder>();}
    for (ComponentRouteSpec item : items) {ComponentRouteSpecBuilder builder = new ComponentRouteSpecBuilder(item);_visitables.get("componentRoutes").add(builder);this.componentRoutes.add(builder);} return (A)this;
  }
  public A addAllToComponentRoutes(Collection<ComponentRouteSpec> items) {
    if (this.componentRoutes == null) {this.componentRoutes = new ArrayList<ComponentRouteSpecBuilder>();}
    for (ComponentRouteSpec item : items) {ComponentRouteSpecBuilder builder = new ComponentRouteSpecBuilder(item);_visitables.get("componentRoutes").add(builder);this.componentRoutes.add(builder);} return (A)this;
  }
  public A removeFromComponentRoutes(io.fabric8.openshift.api.model.config.v1.ComponentRouteSpec... items) {
    for (ComponentRouteSpec item : items) {ComponentRouteSpecBuilder builder = new ComponentRouteSpecBuilder(item);_visitables.get("componentRoutes").remove(builder);if (this.componentRoutes != null) {this.componentRoutes.remove(builder);}} return (A)this;
  }
  public A removeAllFromComponentRoutes(Collection<ComponentRouteSpec> items) {
    for (ComponentRouteSpec item : items) {ComponentRouteSpecBuilder builder = new ComponentRouteSpecBuilder(item);_visitables.get("componentRoutes").remove(builder);if (this.componentRoutes != null) {this.componentRoutes.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromComponentRoutes(Predicate<ComponentRouteSpecBuilder> predicate) {
    if (componentRoutes == null) return (A) this;
    final Iterator<ComponentRouteSpecBuilder> each = componentRoutes.iterator();
    final List visitables = _visitables.get("componentRoutes");
    while (each.hasNext()) {
      ComponentRouteSpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildComponentRoutes instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ComponentRouteSpec> getComponentRoutes() {
    return componentRoutes != null ? build(componentRoutes) : null;
  }
  public List<ComponentRouteSpec> buildComponentRoutes() {
    return componentRoutes != null ? build(componentRoutes) : null;
  }
  public ComponentRouteSpec buildComponentRoute(int index) {
    return this.componentRoutes.get(index).build();
  }
  public ComponentRouteSpec buildFirstComponentRoute() {
    return this.componentRoutes.get(0).build();
  }
  public ComponentRouteSpec buildLastComponentRoute() {
    return this.componentRoutes.get(componentRoutes.size() - 1).build();
  }
  public ComponentRouteSpec buildMatchingComponentRoute(Predicate<ComponentRouteSpecBuilder> predicate) {
    for (ComponentRouteSpecBuilder item: componentRoutes) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingComponentRoute(Predicate<ComponentRouteSpecBuilder> predicate) {
    for (ComponentRouteSpecBuilder item: componentRoutes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withComponentRoutes(List<ComponentRouteSpec> componentRoutes) {
    if (this.componentRoutes != null) { _visitables.get("componentRoutes").clear();}
    if (componentRoutes != null) {this.componentRoutes = new ArrayList(); for (ComponentRouteSpec item : componentRoutes){this.addToComponentRoutes(item);}} else { this.componentRoutes = null;} return (A) this;
  }
  public A withComponentRoutes(io.fabric8.openshift.api.model.config.v1.ComponentRouteSpec... componentRoutes) {
    if (this.componentRoutes != null) {this.componentRoutes.clear(); _visitables.remove("componentRoutes"); }
    if (componentRoutes != null) {for (ComponentRouteSpec item :componentRoutes){ this.addToComponentRoutes(item);}} return (A) this;
  }
  public Boolean hasComponentRoutes() {
    return componentRoutes != null && !componentRoutes.isEmpty();
  }
  public IngressSpecFluentImpl.ComponentRoutesNested<A> addNewComponentRoute() {
    return new IngressSpecFluentImpl.ComponentRoutesNestedImpl();
  }
  public IngressSpecFluentImpl.ComponentRoutesNested<A> addNewComponentRouteLike(ComponentRouteSpec item) {
    return new IngressSpecFluentImpl.ComponentRoutesNestedImpl(-1, item);
  }
  public IngressSpecFluentImpl.ComponentRoutesNested<A> setNewComponentRouteLike(int index,ComponentRouteSpec item) {
    return new IngressSpecFluentImpl.ComponentRoutesNestedImpl(index, item);
  }
  public IngressSpecFluentImpl.ComponentRoutesNested<A> editComponentRoute(int index) {
    if (componentRoutes.size() <= index) throw new RuntimeException("Can't edit componentRoutes. Index exceeds size.");
    return setNewComponentRouteLike(index, buildComponentRoute(index));
  }
  public IngressSpecFluentImpl.ComponentRoutesNested<A> editFirstComponentRoute() {
    if (componentRoutes.size() == 0) throw new RuntimeException("Can't edit first componentRoutes. The list is empty.");
    return setNewComponentRouteLike(0, buildComponentRoute(0));
  }
  public IngressSpecFluentImpl.ComponentRoutesNested<A> editLastComponentRoute() {
    int index = componentRoutes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last componentRoutes. The list is empty.");
    return setNewComponentRouteLike(index, buildComponentRoute(index));
  }
  public IngressSpecFluentImpl.ComponentRoutesNested<A> editMatchingComponentRoute(Predicate<ComponentRouteSpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<componentRoutes.size();i++) { 
    if (predicate.test(componentRoutes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching componentRoutes. No match found.");
    return setNewComponentRouteLike(index, buildComponentRoute(index));
  }
  public String getDomain() {
    return this.domain;
  }
  public A withDomain(String domain) {
    this.domain=domain; return (A) this;
  }
  public Boolean hasDomain() {
    return this.domain != null;
  }
  public A addToRequiredHSTSPolicies(int index,RequiredHSTSPolicy item) {
    if (this.requiredHSTSPolicies == null) {this.requiredHSTSPolicies = new ArrayList<RequiredHSTSPolicyBuilder>();}
    RequiredHSTSPolicyBuilder builder = new RequiredHSTSPolicyBuilder(item);
    if (index < 0 || index >= requiredHSTSPolicies.size()) { _visitables.get("requiredHSTSPolicies").add(builder); requiredHSTSPolicies.add(builder); } else { _visitables.get("requiredHSTSPolicies").add(index, builder); requiredHSTSPolicies.add(index, builder);}
    return (A)this;
  }
  public A setToRequiredHSTSPolicies(int index,RequiredHSTSPolicy item) {
    if (this.requiredHSTSPolicies == null) {this.requiredHSTSPolicies = new ArrayList<RequiredHSTSPolicyBuilder>();}
    RequiredHSTSPolicyBuilder builder = new RequiredHSTSPolicyBuilder(item);
    if (index < 0 || index >= requiredHSTSPolicies.size()) { _visitables.get("requiredHSTSPolicies").add(builder); requiredHSTSPolicies.add(builder); } else { _visitables.get("requiredHSTSPolicies").set(index, builder); requiredHSTSPolicies.set(index, builder);}
    return (A)this;
  }
  public A addToRequiredHSTSPolicies(io.fabric8.openshift.api.model.config.v1.RequiredHSTSPolicy... items) {
    if (this.requiredHSTSPolicies == null) {this.requiredHSTSPolicies = new ArrayList<RequiredHSTSPolicyBuilder>();}
    for (RequiredHSTSPolicy item : items) {RequiredHSTSPolicyBuilder builder = new RequiredHSTSPolicyBuilder(item);_visitables.get("requiredHSTSPolicies").add(builder);this.requiredHSTSPolicies.add(builder);} return (A)this;
  }
  public A addAllToRequiredHSTSPolicies(Collection<RequiredHSTSPolicy> items) {
    if (this.requiredHSTSPolicies == null) {this.requiredHSTSPolicies = new ArrayList<RequiredHSTSPolicyBuilder>();}
    for (RequiredHSTSPolicy item : items) {RequiredHSTSPolicyBuilder builder = new RequiredHSTSPolicyBuilder(item);_visitables.get("requiredHSTSPolicies").add(builder);this.requiredHSTSPolicies.add(builder);} return (A)this;
  }
  public A removeFromRequiredHSTSPolicies(io.fabric8.openshift.api.model.config.v1.RequiredHSTSPolicy... items) {
    for (RequiredHSTSPolicy item : items) {RequiredHSTSPolicyBuilder builder = new RequiredHSTSPolicyBuilder(item);_visitables.get("requiredHSTSPolicies").remove(builder);if (this.requiredHSTSPolicies != null) {this.requiredHSTSPolicies.remove(builder);}} return (A)this;
  }
  public A removeAllFromRequiredHSTSPolicies(Collection<RequiredHSTSPolicy> items) {
    for (RequiredHSTSPolicy item : items) {RequiredHSTSPolicyBuilder builder = new RequiredHSTSPolicyBuilder(item);_visitables.get("requiredHSTSPolicies").remove(builder);if (this.requiredHSTSPolicies != null) {this.requiredHSTSPolicies.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromRequiredHSTSPolicies(Predicate<RequiredHSTSPolicyBuilder> predicate) {
    if (requiredHSTSPolicies == null) return (A) this;
    final Iterator<RequiredHSTSPolicyBuilder> each = requiredHSTSPolicies.iterator();
    final List visitables = _visitables.get("requiredHSTSPolicies");
    while (each.hasNext()) {
      RequiredHSTSPolicyBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildRequiredHSTSPolicies instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<RequiredHSTSPolicy> getRequiredHSTSPolicies() {
    return requiredHSTSPolicies != null ? build(requiredHSTSPolicies) : null;
  }
  public List<RequiredHSTSPolicy> buildRequiredHSTSPolicies() {
    return requiredHSTSPolicies != null ? build(requiredHSTSPolicies) : null;
  }
  public RequiredHSTSPolicy buildRequiredHSTSPolicy(int index) {
    return this.requiredHSTSPolicies.get(index).build();
  }
  public RequiredHSTSPolicy buildFirstRequiredHSTSPolicy() {
    return this.requiredHSTSPolicies.get(0).build();
  }
  public RequiredHSTSPolicy buildLastRequiredHSTSPolicy() {
    return this.requiredHSTSPolicies.get(requiredHSTSPolicies.size() - 1).build();
  }
  public RequiredHSTSPolicy buildMatchingRequiredHSTSPolicy(Predicate<RequiredHSTSPolicyBuilder> predicate) {
    for (RequiredHSTSPolicyBuilder item: requiredHSTSPolicies) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingRequiredHSTSPolicy(Predicate<RequiredHSTSPolicyBuilder> predicate) {
    for (RequiredHSTSPolicyBuilder item: requiredHSTSPolicies) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRequiredHSTSPolicies(List<RequiredHSTSPolicy> requiredHSTSPolicies) {
    if (this.requiredHSTSPolicies != null) { _visitables.get("requiredHSTSPolicies").clear();}
    if (requiredHSTSPolicies != null) {this.requiredHSTSPolicies = new ArrayList(); for (RequiredHSTSPolicy item : requiredHSTSPolicies){this.addToRequiredHSTSPolicies(item);}} else { this.requiredHSTSPolicies = null;} return (A) this;
  }
  public A withRequiredHSTSPolicies(io.fabric8.openshift.api.model.config.v1.RequiredHSTSPolicy... requiredHSTSPolicies) {
    if (this.requiredHSTSPolicies != null) {this.requiredHSTSPolicies.clear(); _visitables.remove("requiredHSTSPolicies"); }
    if (requiredHSTSPolicies != null) {for (RequiredHSTSPolicy item :requiredHSTSPolicies){ this.addToRequiredHSTSPolicies(item);}} return (A) this;
  }
  public Boolean hasRequiredHSTSPolicies() {
    return requiredHSTSPolicies != null && !requiredHSTSPolicies.isEmpty();
  }
  public IngressSpecFluentImpl.RequiredHSTSPoliciesNested<A> addNewRequiredHSTSPolicy() {
    return new IngressSpecFluentImpl.RequiredHSTSPoliciesNestedImpl();
  }
  public IngressSpecFluentImpl.RequiredHSTSPoliciesNested<A> addNewRequiredHSTSPolicyLike(RequiredHSTSPolicy item) {
    return new IngressSpecFluentImpl.RequiredHSTSPoliciesNestedImpl(-1, item);
  }
  public IngressSpecFluentImpl.RequiredHSTSPoliciesNested<A> setNewRequiredHSTSPolicyLike(int index,RequiredHSTSPolicy item) {
    return new IngressSpecFluentImpl.RequiredHSTSPoliciesNestedImpl(index, item);
  }
  public IngressSpecFluentImpl.RequiredHSTSPoliciesNested<A> editRequiredHSTSPolicy(int index) {
    if (requiredHSTSPolicies.size() <= index) throw new RuntimeException("Can't edit requiredHSTSPolicies. Index exceeds size.");
    return setNewRequiredHSTSPolicyLike(index, buildRequiredHSTSPolicy(index));
  }
  public IngressSpecFluentImpl.RequiredHSTSPoliciesNested<A> editFirstRequiredHSTSPolicy() {
    if (requiredHSTSPolicies.size() == 0) throw new RuntimeException("Can't edit first requiredHSTSPolicies. The list is empty.");
    return setNewRequiredHSTSPolicyLike(0, buildRequiredHSTSPolicy(0));
  }
  public IngressSpecFluentImpl.RequiredHSTSPoliciesNested<A> editLastRequiredHSTSPolicy() {
    int index = requiredHSTSPolicies.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last requiredHSTSPolicies. The list is empty.");
    return setNewRequiredHSTSPolicyLike(index, buildRequiredHSTSPolicy(index));
  }
  public IngressSpecFluentImpl.RequiredHSTSPoliciesNested<A> editMatchingRequiredHSTSPolicy(Predicate<RequiredHSTSPolicyBuilder> predicate) {
    int index = -1;
    for (int i=0;i<requiredHSTSPolicies.size();i++) { 
    if (predicate.test(requiredHSTSPolicies.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching requiredHSTSPolicies. No match found.");
    return setNewRequiredHSTSPolicyLike(index, buildRequiredHSTSPolicy(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    IngressSpecFluentImpl that = (IngressSpecFluentImpl) o;
    if (!java.util.Objects.equals(appsDomain, that.appsDomain)) return false;

    if (!java.util.Objects.equals(componentRoutes, that.componentRoutes)) return false;

    if (!java.util.Objects.equals(domain, that.domain)) return false;

    if (!java.util.Objects.equals(requiredHSTSPolicies, that.requiredHSTSPolicies)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(appsDomain,  componentRoutes,  domain,  requiredHSTSPolicies,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (appsDomain != null) { sb.append("appsDomain:"); sb.append(appsDomain + ","); }
    if (componentRoutes != null) { sb.append("componentRoutes:"); sb.append(componentRoutes + ","); }
    if (domain != null) { sb.append("domain:"); sb.append(domain + ","); }
    if (requiredHSTSPolicies != null) { sb.append("requiredHSTSPolicies:"); sb.append(requiredHSTSPolicies + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ComponentRoutesNestedImpl<N> extends ComponentRouteSpecFluentImpl<IngressSpecFluentImpl.ComponentRoutesNested<N>> implements IngressSpecFluentImpl.ComponentRoutesNested<N>,Nested<N>{
    ComponentRoutesNestedImpl(int index,ComponentRouteSpec item) {
      this.index = index;
      this.builder = new ComponentRouteSpecBuilder(this, item);
    }
    ComponentRoutesNestedImpl() {
      this.index = -1;
      this.builder = new ComponentRouteSpecBuilder(this);
    }
    ComponentRouteSpecBuilder builder;
    int index;
    public N and() {
      return (N) IngressSpecFluentImpl.this.setToComponentRoutes(index,builder.build());
    }
    public N endComponentRoute() {
      return and();
    }
    
  }
  class RequiredHSTSPoliciesNestedImpl<N> extends RequiredHSTSPolicyFluentImpl<IngressSpecFluentImpl.RequiredHSTSPoliciesNested<N>> implements IngressSpecFluentImpl.RequiredHSTSPoliciesNested<N>,Nested<N>{
    RequiredHSTSPoliciesNestedImpl(int index,RequiredHSTSPolicy item) {
      this.index = index;
      this.builder = new RequiredHSTSPolicyBuilder(this, item);
    }
    RequiredHSTSPoliciesNestedImpl() {
      this.index = -1;
      this.builder = new RequiredHSTSPolicyBuilder(this);
    }
    RequiredHSTSPolicyBuilder builder;
    int index;
    public N and() {
      return (N) IngressSpecFluentImpl.this.setToRequiredHSTSPolicies(index,builder.build());
    }
    public N endRequiredHSTSPolicy() {
      return and();
    }
    
  }
  
}