package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NetworkSpecBuilder extends NetworkSpecFluentImpl<NetworkSpecBuilder> implements VisitableBuilder<NetworkSpec,NetworkSpecBuilder>{
  public NetworkSpecBuilder() {
    this(false);
  }
  public NetworkSpecBuilder(Boolean validationEnabled) {
    this(new NetworkSpec(), validationEnabled);
  }
  public NetworkSpecBuilder(NetworkSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public NetworkSpecBuilder(NetworkSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NetworkSpec(), validationEnabled);
  }
  public NetworkSpecBuilder(NetworkSpecFluent<?> fluent,NetworkSpec instance) {
    this(fluent, instance, false);
  }
  public NetworkSpecBuilder(NetworkSpecFluent<?> fluent,NetworkSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withClusterNetwork(instance.getClusterNetwork());
      fluent.withExternalIP(instance.getExternalIP());
      fluent.withNetworkType(instance.getNetworkType());
      fluent.withServiceNetwork(instance.getServiceNetwork());
      fluent.withServiceNodePortRange(instance.getServiceNodePortRange());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NetworkSpecBuilder(NetworkSpec instance) {
    this(instance,false);
  }
  public NetworkSpecBuilder(NetworkSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withClusterNetwork(instance.getClusterNetwork());
      this.withExternalIP(instance.getExternalIP());
      this.withNetworkType(instance.getNetworkType());
      this.withServiceNetwork(instance.getServiceNetwork());
      this.withServiceNodePortRange(instance.getServiceNodePortRange());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NetworkSpecFluent<?> fluent;
  Boolean validationEnabled;
  public NetworkSpec build() {
    NetworkSpec buildable = new NetworkSpec(fluent.getClusterNetwork(),fluent.getExternalIP(),fluent.getNetworkType(),fluent.getServiceNetwork(),fluent.getServiceNodePortRange());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}