package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OpenIDClaimsBuilder extends OpenIDClaimsFluentImpl<OpenIDClaimsBuilder> implements VisitableBuilder<OpenIDClaims,OpenIDClaimsBuilder>{
  public OpenIDClaimsBuilder() {
    this(false);
  }
  public OpenIDClaimsBuilder(Boolean validationEnabled) {
    this(new OpenIDClaims(), validationEnabled);
  }
  public OpenIDClaimsBuilder(OpenIDClaimsFluent<?> fluent) {
    this(fluent, false);
  }
  public OpenIDClaimsBuilder(OpenIDClaimsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OpenIDClaims(), validationEnabled);
  }
  public OpenIDClaimsBuilder(OpenIDClaimsFluent<?> fluent,OpenIDClaims instance) {
    this(fluent, instance, false);
  }
  public OpenIDClaimsBuilder(OpenIDClaimsFluent<?> fluent,OpenIDClaims instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withEmail(instance.getEmail());
      fluent.withGroups(instance.getGroups());
      fluent.withName(instance.getName());
      fluent.withPreferredUsername(instance.getPreferredUsername());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OpenIDClaimsBuilder(OpenIDClaims instance) {
    this(instance,false);
  }
  public OpenIDClaimsBuilder(OpenIDClaims instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withEmail(instance.getEmail());
      this.withGroups(instance.getGroups());
      this.withName(instance.getName());
      this.withPreferredUsername(instance.getPreferredUsername());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  OpenIDClaimsFluent<?> fluent;
  Boolean validationEnabled;
  public OpenIDClaims build() {
    OpenIDClaims buildable = new OpenIDClaims(fluent.getEmail(),fluent.getGroups(),fluent.getName(),fluent.getPreferredUsername());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}