package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ProjectStatusBuilder extends ProjectStatusFluentImpl<ProjectStatusBuilder> implements VisitableBuilder<ProjectStatus,ProjectStatusBuilder>{
  public ProjectStatusBuilder() {
    this(false);
  }
  public ProjectStatusBuilder(Boolean validationEnabled) {
    this(new ProjectStatus(), validationEnabled);
  }
  public ProjectStatusBuilder(ProjectStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ProjectStatusBuilder(ProjectStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ProjectStatus(), validationEnabled);
  }
  public ProjectStatusBuilder(ProjectStatusFluent<?> fluent,ProjectStatus instance) {
    this(fluent, instance, false);
  }
  public ProjectStatusBuilder(ProjectStatusFluent<?> fluent,ProjectStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ProjectStatusBuilder(ProjectStatus instance) {
    this(instance,false);
  }
  public ProjectStatusBuilder(ProjectStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ProjectStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ProjectStatus build() {
    ProjectStatus buildable = new ProjectStatus();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}