package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PromQLClusterConditionBuilder extends PromQLClusterConditionFluentImpl<PromQLClusterConditionBuilder> implements VisitableBuilder<PromQLClusterCondition,PromQLClusterConditionBuilder>{
  public PromQLClusterConditionBuilder() {
    this(false);
  }
  public PromQLClusterConditionBuilder(Boolean validationEnabled) {
    this(new PromQLClusterCondition(), validationEnabled);
  }
  public PromQLClusterConditionBuilder(PromQLClusterConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public PromQLClusterConditionBuilder(PromQLClusterConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PromQLClusterCondition(), validationEnabled);
  }
  public PromQLClusterConditionBuilder(PromQLClusterConditionFluent<?> fluent,PromQLClusterCondition instance) {
    this(fluent, instance, false);
  }
  public PromQLClusterConditionBuilder(PromQLClusterConditionFluent<?> fluent,PromQLClusterCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withPromql(instance.getPromql());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PromQLClusterConditionBuilder(PromQLClusterCondition instance) {
    this(instance,false);
  }
  public PromQLClusterConditionBuilder(PromQLClusterCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withPromql(instance.getPromql());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PromQLClusterConditionFluent<?> fluent;
  Boolean validationEnabled;
  public PromQLClusterCondition build() {
    PromQLClusterCondition buildable = new PromQLClusterCondition(fluent.getPromql());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}