package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ProxyBuilder extends ProxyFluentImpl<ProxyBuilder> implements VisitableBuilder<Proxy,ProxyBuilder>{
  public ProxyBuilder() {
    this(false);
  }
  public ProxyBuilder(Boolean validationEnabled) {
    this(new Proxy(), validationEnabled);
  }
  public ProxyBuilder(ProxyFluent<?> fluent) {
    this(fluent, false);
  }
  public ProxyBuilder(ProxyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Proxy(), validationEnabled);
  }
  public ProxyBuilder(ProxyFluent<?> fluent,Proxy instance) {
    this(fluent, instance, false);
  }
  public ProxyBuilder(ProxyFluent<?> fluent,Proxy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ProxyBuilder(Proxy instance) {
    this(instance,false);
  }
  public ProxyBuilder(Proxy instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ProxyFluent<?> fluent;
  Boolean validationEnabled;
  public Proxy build() {
    Proxy buildable = new Proxy(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}