package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RegistrySourcesBuilder extends RegistrySourcesFluentImpl<RegistrySourcesBuilder> implements VisitableBuilder<RegistrySources,RegistrySourcesBuilder>{
  public RegistrySourcesBuilder() {
    this(false);
  }
  public RegistrySourcesBuilder(Boolean validationEnabled) {
    this(new RegistrySources(), validationEnabled);
  }
  public RegistrySourcesBuilder(RegistrySourcesFluent<?> fluent) {
    this(fluent, false);
  }
  public RegistrySourcesBuilder(RegistrySourcesFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RegistrySources(), validationEnabled);
  }
  public RegistrySourcesBuilder(RegistrySourcesFluent<?> fluent,RegistrySources instance) {
    this(fluent, instance, false);
  }
  public RegistrySourcesBuilder(RegistrySourcesFluent<?> fluent,RegistrySources instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAllowedRegistries(instance.getAllowedRegistries());
      fluent.withBlockedRegistries(instance.getBlockedRegistries());
      fluent.withContainerRuntimeSearchRegistries(instance.getContainerRuntimeSearchRegistries());
      fluent.withInsecureRegistries(instance.getInsecureRegistries());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RegistrySourcesBuilder(RegistrySources instance) {
    this(instance,false);
  }
  public RegistrySourcesBuilder(RegistrySources instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAllowedRegistries(instance.getAllowedRegistries());
      this.withBlockedRegistries(instance.getBlockedRegistries());
      this.withContainerRuntimeSearchRegistries(instance.getContainerRuntimeSearchRegistries());
      this.withInsecureRegistries(instance.getInsecureRegistries());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  RegistrySourcesFluent<?> fluent;
  Boolean validationEnabled;
  public RegistrySources build() {
    RegistrySources buildable = new RegistrySources(fluent.getAllowedRegistries(),fluent.getBlockedRegistries(),fluent.getContainerRuntimeSearchRegistries(),fluent.getInsecureRegistries());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}