package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class APIServerNamedServingCertFluent<A extends APIServerNamedServingCertFluent<A>> extends BaseFluent<A>{
  public APIServerNamedServingCertFluent() {
  }
  public APIServerNamedServingCertFluent(APIServerNamedServingCert instance) {
    instance = (instance != null ? instance : new APIServerNamedServingCert());

    if (instance != null) {
      this.withNames(instance.getNames());
      this.withServingCertificate(instance.getServingCertificate());
      this.withNames(instance.getNames());
      this.withServingCertificate(instance.getServingCertificate());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private List<String> names = new ArrayList<String>();
  private SecretNameReferenceBuilder servingCertificate;
  private Map<String,Object> additionalProperties;
  public A addToNames(int index,String item) {
    if (this.names == null) {this.names = new ArrayList<String>();}
    this.names.add(index, item);
    return (A)this;
  }
  public A setToNames(int index,String item) {
    if (this.names == null) {this.names = new ArrayList<String>();}
    this.names.set(index, item); return (A)this;
  }
  public A addToNames(java.lang.String... items) {
    if (this.names == null) {this.names = new ArrayList<String>();}
    for (String item : items) {this.names.add(item);} return (A)this;
  }
  public A addAllToNames(Collection<String> items) {
    if (this.names == null) {this.names = new ArrayList<String>();}
    for (String item : items) {this.names.add(item);} return (A)this;
  }
  public A removeFromNames(java.lang.String... items) {
    if (this.names == null) return (A)this;
    for (String item : items) { this.names.remove(item);} return (A)this;
  }
  public A removeAllFromNames(Collection<String> items) {
    if (this.names == null) return (A)this;
    for (String item : items) { this.names.remove(item);} return (A)this;
  }
  public List<String> getNames() {
    return this.names;
  }
  public String getName(int index) {
    return this.names.get(index);
  }
  public String getFirstName() {
    return this.names.get(0);
  }
  public String getLastName() {
    return this.names.get(names.size() - 1);
  }
  public String getMatchingName(Predicate<String> predicate) {
    for (String item: names) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingName(Predicate<String> predicate) {
    for (String item: names) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withNames(List<String> names) {
    if (names != null) {this.names = new ArrayList(); for (String item : names){this.addToNames(item);}} else { this.names = null;} return (A) this;
  }
  public A withNames(java.lang.String... names) {
    if (this.names != null) {this.names.clear(); _visitables.remove("names"); }
    if (names != null) {for (String item :names){ this.addToNames(item);}} return (A) this;
  }
  public boolean hasNames() {
    return names != null && !names.isEmpty();
  }
  public SecretNameReference buildServingCertificate() {
    return this.servingCertificate!=null ?this.servingCertificate.build():null;
  }
  public A withServingCertificate(SecretNameReference servingCertificate) {
    _visitables.get("servingCertificate").remove(this.servingCertificate);
    if (servingCertificate!=null){ this.servingCertificate= new SecretNameReferenceBuilder(servingCertificate); _visitables.get("servingCertificate").add(this.servingCertificate);} else { this.servingCertificate = null; _visitables.get("servingCertificate").remove(this.servingCertificate); } return (A) this;
  }
  public boolean hasServingCertificate() {
    return this.servingCertificate != null;
  }
  public A withNewServingCertificate(String name) {
    return (A)withServingCertificate(new SecretNameReference(name));
  }
  public ServingCertificateNested<A> withNewServingCertificate() {
    return new ServingCertificateNested(null);
  }
  public ServingCertificateNested<A> withNewServingCertificateLike(SecretNameReference item) {
    return new ServingCertificateNested(item);
  }
  public ServingCertificateNested<A> editServingCertificate() {
    return withNewServingCertificateLike(java.util.Optional.ofNullable(buildServingCertificate()).orElse(null));
  }
  public ServingCertificateNested<A> editOrNewServingCertificate() {
    return withNewServingCertificateLike(java.util.Optional.ofNullable(buildServingCertificate()).orElse(new SecretNameReferenceBuilder().build()));
  }
  public ServingCertificateNested<A> editOrNewServingCertificateLike(SecretNameReference item) {
    return withNewServingCertificateLike(java.util.Optional.ofNullable(buildServingCertificate()).orElse(item));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    APIServerNamedServingCertFluent that = (APIServerNamedServingCertFluent) o;
    if (!java.util.Objects.equals(names, that.names)) return false;

    if (!java.util.Objects.equals(servingCertificate, that.servingCertificate)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(names,  servingCertificate,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (names != null && !names.isEmpty()) { sb.append("names:"); sb.append(names + ","); }
    if (servingCertificate != null) { sb.append("servingCertificate:"); sb.append(servingCertificate + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ServingCertificateNested<N> extends SecretNameReferenceFluent<ServingCertificateNested<N>> implements Nested<N>{
    ServingCertificateNested(SecretNameReference item) {
      this.builder = new SecretNameReferenceBuilder(this, item);
    }
    SecretNameReferenceBuilder builder;
    public N and() {
      return (N) APIServerNamedServingCertFluent.this.withServingCertificate(builder.build());
    }
    public N endServingCertificate() {
      return and();
    }
    
  }
  
}