package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class APIServerServingCertsBuilder extends APIServerServingCertsFluent<APIServerServingCertsBuilder> implements VisitableBuilder<APIServerServingCerts,APIServerServingCertsBuilder>{
  public APIServerServingCertsBuilder() {
    this(false);
  }
  public APIServerServingCertsBuilder(Boolean validationEnabled) {
    this(new APIServerServingCerts(), validationEnabled);
  }
  public APIServerServingCertsBuilder(APIServerServingCertsFluent<?> fluent) {
    this(fluent, false);
  }
  public APIServerServingCertsBuilder(APIServerServingCertsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new APIServerServingCerts(), validationEnabled);
  }
  public APIServerServingCertsBuilder(APIServerServingCertsFluent<?> fluent,APIServerServingCerts instance) {
    this(fluent, instance, false);
  }
  public APIServerServingCertsBuilder(APIServerServingCertsFluent<?> fluent,APIServerServingCerts instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new APIServerServingCerts());

    if (instance != null) {
      fluent.withNamedCertificates(instance.getNamedCertificates());
      fluent.withNamedCertificates(instance.getNamedCertificates());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public APIServerServingCertsBuilder(APIServerServingCerts instance) {
    this(instance,false);
  }
  public APIServerServingCertsBuilder(APIServerServingCerts instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new APIServerServingCerts());

    if (instance != null) {
      this.withNamedCertificates(instance.getNamedCertificates());
      this.withNamedCertificates(instance.getNamedCertificates());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  APIServerServingCertsFluent<?> fluent;
  Boolean validationEnabled;
  public APIServerServingCerts build() {
    APIServerServingCerts buildable = new APIServerServingCerts(fluent.buildNamedCertificates());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}