package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class APIServerSpecBuilder extends APIServerSpecFluent<APIServerSpecBuilder> implements VisitableBuilder<APIServerSpec,APIServerSpecBuilder>{
  public APIServerSpecBuilder() {
    this(false);
  }
  public APIServerSpecBuilder(Boolean validationEnabled) {
    this(new APIServerSpec(), validationEnabled);
  }
  public APIServerSpecBuilder(APIServerSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public APIServerSpecBuilder(APIServerSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new APIServerSpec(), validationEnabled);
  }
  public APIServerSpecBuilder(APIServerSpecFluent<?> fluent,APIServerSpec instance) {
    this(fluent, instance, false);
  }
  public APIServerSpecBuilder(APIServerSpecFluent<?> fluent,APIServerSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new APIServerSpec());

    if (instance != null) {
      fluent.withAdditionalCORSAllowedOrigins(instance.getAdditionalCORSAllowedOrigins());
      fluent.withAudit(instance.getAudit());
      fluent.withClientCA(instance.getClientCA());
      fluent.withEncryption(instance.getEncryption());
      fluent.withServingCerts(instance.getServingCerts());
      fluent.withTlsSecurityProfile(instance.getTlsSecurityProfile());
      fluent.withAdditionalCORSAllowedOrigins(instance.getAdditionalCORSAllowedOrigins());
      fluent.withAudit(instance.getAudit());
      fluent.withClientCA(instance.getClientCA());
      fluent.withEncryption(instance.getEncryption());
      fluent.withServingCerts(instance.getServingCerts());
      fluent.withTlsSecurityProfile(instance.getTlsSecurityProfile());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public APIServerSpecBuilder(APIServerSpec instance) {
    this(instance,false);
  }
  public APIServerSpecBuilder(APIServerSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new APIServerSpec());

    if (instance != null) {
      this.withAdditionalCORSAllowedOrigins(instance.getAdditionalCORSAllowedOrigins());
      this.withAudit(instance.getAudit());
      this.withClientCA(instance.getClientCA());
      this.withEncryption(instance.getEncryption());
      this.withServingCerts(instance.getServingCerts());
      this.withTlsSecurityProfile(instance.getTlsSecurityProfile());
      this.withAdditionalCORSAllowedOrigins(instance.getAdditionalCORSAllowedOrigins());
      this.withAudit(instance.getAudit());
      this.withClientCA(instance.getClientCA());
      this.withEncryption(instance.getEncryption());
      this.withServingCerts(instance.getServingCerts());
      this.withTlsSecurityProfile(instance.getTlsSecurityProfile());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  APIServerSpecFluent<?> fluent;
  Boolean validationEnabled;
  public APIServerSpec build() {
    APIServerSpec buildable = new APIServerSpec(fluent.getAdditionalCORSAllowedOrigins(),fluent.buildAudit(),fluent.buildClientCA(),fluent.buildEncryption(),fluent.buildServingCerts(),fluent.buildTlsSecurityProfile());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}