package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BareMetalPlatformSpecBuilder extends BareMetalPlatformSpecFluent<BareMetalPlatformSpecBuilder> implements VisitableBuilder<BareMetalPlatformSpec,BareMetalPlatformSpecBuilder>{
  public BareMetalPlatformSpecBuilder() {
    this(false);
  }
  public BareMetalPlatformSpecBuilder(Boolean validationEnabled) {
    this(new BareMetalPlatformSpec(), validationEnabled);
  }
  public BareMetalPlatformSpecBuilder(BareMetalPlatformSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public BareMetalPlatformSpecBuilder(BareMetalPlatformSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BareMetalPlatformSpec(), validationEnabled);
  }
  public BareMetalPlatformSpecBuilder(BareMetalPlatformSpecFluent<?> fluent,BareMetalPlatformSpec instance) {
    this(fluent, instance, false);
  }
  public BareMetalPlatformSpecBuilder(BareMetalPlatformSpecFluent<?> fluent,BareMetalPlatformSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new BareMetalPlatformSpec());

    if (instance != null) {
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public BareMetalPlatformSpecBuilder(BareMetalPlatformSpec instance) {
    this(instance,false);
  }
  public BareMetalPlatformSpecBuilder(BareMetalPlatformSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new BareMetalPlatformSpec());

    if (instance != null) {
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  BareMetalPlatformSpecFluent<?> fluent;
  Boolean validationEnabled;
  public BareMetalPlatformSpec build() {
    BareMetalPlatformSpec buildable = new BareMetalPlatformSpec();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}