package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterVersionCapabilitiesSpecBuilder extends ClusterVersionCapabilitiesSpecFluent<ClusterVersionCapabilitiesSpecBuilder> implements VisitableBuilder<ClusterVersionCapabilitiesSpec,ClusterVersionCapabilitiesSpecBuilder>{
  public ClusterVersionCapabilitiesSpecBuilder() {
    this(false);
  }
  public ClusterVersionCapabilitiesSpecBuilder(Boolean validationEnabled) {
    this(new ClusterVersionCapabilitiesSpec(), validationEnabled);
  }
  public ClusterVersionCapabilitiesSpecBuilder(ClusterVersionCapabilitiesSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterVersionCapabilitiesSpecBuilder(ClusterVersionCapabilitiesSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterVersionCapabilitiesSpec(), validationEnabled);
  }
  public ClusterVersionCapabilitiesSpecBuilder(ClusterVersionCapabilitiesSpecFluent<?> fluent,ClusterVersionCapabilitiesSpec instance) {
    this(fluent, instance, false);
  }
  public ClusterVersionCapabilitiesSpecBuilder(ClusterVersionCapabilitiesSpecFluent<?> fluent,ClusterVersionCapabilitiesSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ClusterVersionCapabilitiesSpec());

    if (instance != null) {
      fluent.withAdditionalEnabledCapabilities(instance.getAdditionalEnabledCapabilities());
      fluent.withBaselineCapabilitySet(instance.getBaselineCapabilitySet());
      fluent.withAdditionalEnabledCapabilities(instance.getAdditionalEnabledCapabilities());
      fluent.withBaselineCapabilitySet(instance.getBaselineCapabilitySet());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterVersionCapabilitiesSpecBuilder(ClusterVersionCapabilitiesSpec instance) {
    this(instance,false);
  }
  public ClusterVersionCapabilitiesSpecBuilder(ClusterVersionCapabilitiesSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ClusterVersionCapabilitiesSpec());

    if (instance != null) {
      this.withAdditionalEnabledCapabilities(instance.getAdditionalEnabledCapabilities());
      this.withBaselineCapabilitySet(instance.getBaselineCapabilitySet());
      this.withAdditionalEnabledCapabilities(instance.getAdditionalEnabledCapabilities());
      this.withBaselineCapabilitySet(instance.getBaselineCapabilitySet());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterVersionCapabilitiesSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterVersionCapabilitiesSpec build() {
    ClusterVersionCapabilitiesSpec buildable = new ClusterVersionCapabilitiesSpec(fluent.getAdditionalEnabledCapabilities(),fluent.getBaselineCapabilitySet());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}