package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterVersionCapabilitiesStatusBuilder extends ClusterVersionCapabilitiesStatusFluent<ClusterVersionCapabilitiesStatusBuilder> implements VisitableBuilder<ClusterVersionCapabilitiesStatus,ClusterVersionCapabilitiesStatusBuilder>{
  public ClusterVersionCapabilitiesStatusBuilder() {
    this(false);
  }
  public ClusterVersionCapabilitiesStatusBuilder(Boolean validationEnabled) {
    this(new ClusterVersionCapabilitiesStatus(), validationEnabled);
  }
  public ClusterVersionCapabilitiesStatusBuilder(ClusterVersionCapabilitiesStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterVersionCapabilitiesStatusBuilder(ClusterVersionCapabilitiesStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterVersionCapabilitiesStatus(), validationEnabled);
  }
  public ClusterVersionCapabilitiesStatusBuilder(ClusterVersionCapabilitiesStatusFluent<?> fluent,ClusterVersionCapabilitiesStatus instance) {
    this(fluent, instance, false);
  }
  public ClusterVersionCapabilitiesStatusBuilder(ClusterVersionCapabilitiesStatusFluent<?> fluent,ClusterVersionCapabilitiesStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ClusterVersionCapabilitiesStatus());

    if (instance != null) {
      fluent.withEnabledCapabilities(instance.getEnabledCapabilities());
      fluent.withKnownCapabilities(instance.getKnownCapabilities());
      fluent.withEnabledCapabilities(instance.getEnabledCapabilities());
      fluent.withKnownCapabilities(instance.getKnownCapabilities());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterVersionCapabilitiesStatusBuilder(ClusterVersionCapabilitiesStatus instance) {
    this(instance,false);
  }
  public ClusterVersionCapabilitiesStatusBuilder(ClusterVersionCapabilitiesStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ClusterVersionCapabilitiesStatus());

    if (instance != null) {
      this.withEnabledCapabilities(instance.getEnabledCapabilities());
      this.withKnownCapabilities(instance.getKnownCapabilities());
      this.withEnabledCapabilities(instance.getEnabledCapabilities());
      this.withKnownCapabilities(instance.getKnownCapabilities());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterVersionCapabilitiesStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterVersionCapabilitiesStatus build() {
    ClusterVersionCapabilitiesStatus buildable = new ClusterVersionCapabilitiesStatus(fluent.getEnabledCapabilities(),fluent.getKnownCapabilities());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}