package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;
import java.util.function.Predicate;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ClusterVersionCapabilitiesStatusFluent<A extends ClusterVersionCapabilitiesStatusFluent<A>> extends BaseFluent<A>{
  public ClusterVersionCapabilitiesStatusFluent() {
  }
  public ClusterVersionCapabilitiesStatusFluent(ClusterVersionCapabilitiesStatus instance) {
    instance = (instance != null ? instance : new ClusterVersionCapabilitiesStatus());

    if (instance != null) {
      this.withEnabledCapabilities(instance.getEnabledCapabilities());
      this.withKnownCapabilities(instance.getKnownCapabilities());
      this.withEnabledCapabilities(instance.getEnabledCapabilities());
      this.withKnownCapabilities(instance.getKnownCapabilities());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private List<String> enabledCapabilities = new ArrayList<String>();
  private List<String> knownCapabilities = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  public A addToEnabledCapabilities(int index,String item) {
    if (this.enabledCapabilities == null) {this.enabledCapabilities = new ArrayList<String>();}
    this.enabledCapabilities.add(index, item);
    return (A)this;
  }
  public A setToEnabledCapabilities(int index,String item) {
    if (this.enabledCapabilities == null) {this.enabledCapabilities = new ArrayList<String>();}
    this.enabledCapabilities.set(index, item); return (A)this;
  }
  public A addToEnabledCapabilities(java.lang.String... items) {
    if (this.enabledCapabilities == null) {this.enabledCapabilities = new ArrayList<String>();}
    for (String item : items) {this.enabledCapabilities.add(item);} return (A)this;
  }
  public A addAllToEnabledCapabilities(Collection<String> items) {
    if (this.enabledCapabilities == null) {this.enabledCapabilities = new ArrayList<String>();}
    for (String item : items) {this.enabledCapabilities.add(item);} return (A)this;
  }
  public A removeFromEnabledCapabilities(java.lang.String... items) {
    if (this.enabledCapabilities == null) return (A)this;
    for (String item : items) { this.enabledCapabilities.remove(item);} return (A)this;
  }
  public A removeAllFromEnabledCapabilities(Collection<String> items) {
    if (this.enabledCapabilities == null) return (A)this;
    for (String item : items) { this.enabledCapabilities.remove(item);} return (A)this;
  }
  public List<String> getEnabledCapabilities() {
    return this.enabledCapabilities;
  }
  public String getEnabledCapability(int index) {
    return this.enabledCapabilities.get(index);
  }
  public String getFirstEnabledCapability() {
    return this.enabledCapabilities.get(0);
  }
  public String getLastEnabledCapability() {
    return this.enabledCapabilities.get(enabledCapabilities.size() - 1);
  }
  public String getMatchingEnabledCapability(Predicate<String> predicate) {
    for (String item: enabledCapabilities) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingEnabledCapability(Predicate<String> predicate) {
    for (String item: enabledCapabilities) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEnabledCapabilities(List<String> enabledCapabilities) {
    if (enabledCapabilities != null) {this.enabledCapabilities = new ArrayList(); for (String item : enabledCapabilities){this.addToEnabledCapabilities(item);}} else { this.enabledCapabilities = null;} return (A) this;
  }
  public A withEnabledCapabilities(java.lang.String... enabledCapabilities) {
    if (this.enabledCapabilities != null) {this.enabledCapabilities.clear(); _visitables.remove("enabledCapabilities"); }
    if (enabledCapabilities != null) {for (String item :enabledCapabilities){ this.addToEnabledCapabilities(item);}} return (A) this;
  }
  public boolean hasEnabledCapabilities() {
    return enabledCapabilities != null && !enabledCapabilities.isEmpty();
  }
  public A addToKnownCapabilities(int index,String item) {
    if (this.knownCapabilities == null) {this.knownCapabilities = new ArrayList<String>();}
    this.knownCapabilities.add(index, item);
    return (A)this;
  }
  public A setToKnownCapabilities(int index,String item) {
    if (this.knownCapabilities == null) {this.knownCapabilities = new ArrayList<String>();}
    this.knownCapabilities.set(index, item); return (A)this;
  }
  public A addToKnownCapabilities(java.lang.String... items) {
    if (this.knownCapabilities == null) {this.knownCapabilities = new ArrayList<String>();}
    for (String item : items) {this.knownCapabilities.add(item);} return (A)this;
  }
  public A addAllToKnownCapabilities(Collection<String> items) {
    if (this.knownCapabilities == null) {this.knownCapabilities = new ArrayList<String>();}
    for (String item : items) {this.knownCapabilities.add(item);} return (A)this;
  }
  public A removeFromKnownCapabilities(java.lang.String... items) {
    if (this.knownCapabilities == null) return (A)this;
    for (String item : items) { this.knownCapabilities.remove(item);} return (A)this;
  }
  public A removeAllFromKnownCapabilities(Collection<String> items) {
    if (this.knownCapabilities == null) return (A)this;
    for (String item : items) { this.knownCapabilities.remove(item);} return (A)this;
  }
  public List<String> getKnownCapabilities() {
    return this.knownCapabilities;
  }
  public String getKnownCapability(int index) {
    return this.knownCapabilities.get(index);
  }
  public String getFirstKnownCapability() {
    return this.knownCapabilities.get(0);
  }
  public String getLastKnownCapability() {
    return this.knownCapabilities.get(knownCapabilities.size() - 1);
  }
  public String getMatchingKnownCapability(Predicate<String> predicate) {
    for (String item: knownCapabilities) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingKnownCapability(Predicate<String> predicate) {
    for (String item: knownCapabilities) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withKnownCapabilities(List<String> knownCapabilities) {
    if (knownCapabilities != null) {this.knownCapabilities = new ArrayList(); for (String item : knownCapabilities){this.addToKnownCapabilities(item);}} else { this.knownCapabilities = null;} return (A) this;
  }
  public A withKnownCapabilities(java.lang.String... knownCapabilities) {
    if (this.knownCapabilities != null) {this.knownCapabilities.clear(); _visitables.remove("knownCapabilities"); }
    if (knownCapabilities != null) {for (String item :knownCapabilities){ this.addToKnownCapabilities(item);}} return (A) this;
  }
  public boolean hasKnownCapabilities() {
    return knownCapabilities != null && !knownCapabilities.isEmpty();
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterVersionCapabilitiesStatusFluent that = (ClusterVersionCapabilitiesStatusFluent) o;
    if (!java.util.Objects.equals(enabledCapabilities, that.enabledCapabilities)) return false;

    if (!java.util.Objects.equals(knownCapabilities, that.knownCapabilities)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(enabledCapabilities,  knownCapabilities,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (enabledCapabilities != null && !enabledCapabilities.isEmpty()) { sb.append("enabledCapabilities:"); sb.append(enabledCapabilities + ","); }
    if (knownCapabilities != null && !knownCapabilities.isEmpty()) { sb.append("knownCapabilities:"); sb.append(knownCapabilities + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}