package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterVersionListBuilder extends ClusterVersionListFluent<ClusterVersionListBuilder> implements VisitableBuilder<ClusterVersionList,ClusterVersionListBuilder>{
  public ClusterVersionListBuilder() {
    this(false);
  }
  public ClusterVersionListBuilder(Boolean validationEnabled) {
    this(new ClusterVersionList(), validationEnabled);
  }
  public ClusterVersionListBuilder(ClusterVersionListFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterVersionListBuilder(ClusterVersionListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterVersionList(), validationEnabled);
  }
  public ClusterVersionListBuilder(ClusterVersionListFluent<?> fluent,ClusterVersionList instance) {
    this(fluent, instance, false);
  }
  public ClusterVersionListBuilder(ClusterVersionListFluent<?> fluent,ClusterVersionList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ClusterVersionList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterVersionListBuilder(ClusterVersionList instance) {
    this(instance,false);
  }
  public ClusterVersionListBuilder(ClusterVersionList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ClusterVersionList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterVersionListFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterVersionList build() {
    ClusterVersionList buildable = new ClusterVersionList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}