package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ComponentRouteSpecBuilder extends ComponentRouteSpecFluent<ComponentRouteSpecBuilder> implements VisitableBuilder<ComponentRouteSpec,ComponentRouteSpecBuilder>{
  public ComponentRouteSpecBuilder() {
    this(false);
  }
  public ComponentRouteSpecBuilder(Boolean validationEnabled) {
    this(new ComponentRouteSpec(), validationEnabled);
  }
  public ComponentRouteSpecBuilder(ComponentRouteSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ComponentRouteSpecBuilder(ComponentRouteSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ComponentRouteSpec(), validationEnabled);
  }
  public ComponentRouteSpecBuilder(ComponentRouteSpecFluent<?> fluent,ComponentRouteSpec instance) {
    this(fluent, instance, false);
  }
  public ComponentRouteSpecBuilder(ComponentRouteSpecFluent<?> fluent,ComponentRouteSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ComponentRouteSpec());

    if (instance != null) {
      fluent.withHostname(instance.getHostname());
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withServingCertKeyPairSecret(instance.getServingCertKeyPairSecret());
      fluent.withHostname(instance.getHostname());
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withServingCertKeyPairSecret(instance.getServingCertKeyPairSecret());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ComponentRouteSpecBuilder(ComponentRouteSpec instance) {
    this(instance,false);
  }
  public ComponentRouteSpecBuilder(ComponentRouteSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ComponentRouteSpec());

    if (instance != null) {
      this.withHostname(instance.getHostname());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withServingCertKeyPairSecret(instance.getServingCertKeyPairSecret());
      this.withHostname(instance.getHostname());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withServingCertKeyPairSecret(instance.getServingCertKeyPairSecret());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ComponentRouteSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ComponentRouteSpec build() {
    ComponentRouteSpec buildable = new ComponentRouteSpec(fluent.getHostname(),fluent.getName(),fluent.getNamespace(),fluent.buildServingCertKeyPairSecret());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}